% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Args.R
\name{matchInList}
\alias{matchInList}
\title{In a list of object of the same type, find those that match the input}
\usage{
matchInList(x, toMatch)
}
\arguments{
\item{x}{A list of objects of the same type.}

\item{toMatch}{The object to match.}
}
\value{
A list of objects that match the \code{toMatch} object.
}
\description{
In a list of object of the same type, find those that match the input
}
\details{
Typically, toMatch will contain a subset of the variables that are in the objects in the list. Any
object matching all variables in \code{toMatch} will be included in the result.
}
\examples{
x <- list(
  a = list(name = "John", age = 25, gender = "M"),
  b = list(name = "Mary", age = 24, gender = "F")
)

matchInList(x, list(name = "Mary"))

# $a
# $a$name
# [1] "John"
#
# $a$age
# [1] 25
#
#
# $b
# $b$name
# [1] "Mary"
#
# $b$age
# [1] 24
}
