% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParallelInit.R
\name{ParallelInit_Test}
\alias{ParallelInit_Test}
\title{Data initialization function is the first step to complete parallel training}
\usage{
ParallelInit_Test(
  fn = "",
  icsv = NULL,
  dsmformula = NULL,
  nblock = 6,
  ncore = 2
)
}
\arguments{
\item{fn}{: Name of the folder in which the soil data is stored}

\item{icsv}{: Use df.input from the built-in dataset}

\item{nblock}{: the number of blocks for data cutting}

\item{ncore}{: Computes the CPU's kernel in parallel(fill in according to the computer configuration)}

\item{dsmformula}{: Symbolic description of a soil fitting model}
}
\description{
Data initialization function is the first step to complete parallel training
}
\examples{
#####################################################################
##  Example code 1                                                 ##
##  Select your own reading method, as shown below                 ##
#####################################################################
mydatas <- system.file("extdata", "all.input.csv", package = "ParallelDSM")
sampledatas <- system.file("extdata", "covariate", package = "ParallelDSM")
ParallelInit(mydatas,sampledatas,"socd030 ~ twi + dem + pa")

#####################################################################
##  Example code 2 (It is highly recommended)                      ##
##  If you want to use test cases, load the relevant data sets     ##
##  Select the data set that comes with this package

library(ParallelDSM)
data("df.input",package = "ParallelDSM")
data("df.dem",package = "ParallelDSM")
data("df.twi",package = "ParallelDSM")
sampledata <- system.file("extdata", "covariate", package = "ParallelDSM")
ParallelInit_Test(sampledata,df.input,dsmformula = "socd030 ~ twi + dem")
#ParallelComputing(outpath = "qrfOutput",mymodels = "QRF")

#####################################################################
##  Use the data file references that come with this package       ##
#####################################################################
#sampledatas <- system.file("extdata", "covariate", package = "ParallelDSM")

#####################################################################
## Use ParallelInit functions to process the data that is loaded in##
#####################################################################
#ParallelInit_Test(sampledata,df.input,dsmformula = "socd030 ~ dem + twi")

############################################################################
## This function is the main function that performs parallel computations ##
## The outpath field refers to the filename of the data output            ##
## The mymodels field has three modes to choose from: QRF,RF and MLR      ##
## 'QRF' stands for Random Forest Model Prediction Method                 ##
## 'RF' stands for Machine Learning Model Prediction Method               ##
## 'MLR' stands for Multiple Linear Regression Prediction Model           ##
############################################################################

#ParallelComputing(outpath = "myoutputs",mymodels = "MLR",from=1,to=200)


}
\references{
{
Breiman, L. (2001). Random forests. Mach. Learn. 45, 5–32.
Meinshausen, N. (2006) "Quantile Regression Forests", Journal of Machine Learning Research 7,
983-999 http://jmlr.csail.mit.edu/papers/v7/
}
}
