% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLocalOptimums.R
\name{getLocalOptimums}
\alias{getLocalOptimums}
\title{Get Local Optimums of acq From a bayesOpt Object}
\usage{
getLocalOptimums(
  optObj,
  bounds = optObj$bounds,
  acq = optObj$optPars$acq,
  kappa = optObj$optPars$kappa,
  eps = optObj$optPars$eps,
  convThresh = optObj$optPars$convThresh,
  gsPoints = optObj$optPars$gsPoints,
  parallel = FALSE,
  verbose = 1
)
}
\arguments{
\item{optObj}{an object of class \code{bayesOpt}. The following parameters are all defaulted to
the options provided in this object, but can be manually specified.}

\item{bounds}{Same as in \code{bayesOpt()}}

\item{acq}{Same as in \code{bayesOpt()}}

\item{kappa}{Same as in \code{bayesOpt()}}

\item{eps}{Same as in \code{bayesOpt()}}

\item{convThresh}{Same as in \code{bayesOpt()}}

\item{gsPoints}{Same as in \code{bayesOpt()}}

\item{parallel}{Same as in \code{bayesOpt()}}

\item{verbose}{Should warnings be shown before results are returned prematurely?}
}
\value{
A data table of local optimums, including the utility (gpUtility), the
utility relative to the max utility (relUtility), and the steps taken in the
L-BFGS-B method (gradCount).
}
\description{
Returns all local optimums of the acquisition function, no matter the utility.
}
\details{
\code{gsPoints} points in the parameter space are randomly initialized, and
the L-BFGS-B method is used to find the closest local optimum to each point.
dbscan is then used to cluster points together which converged to the same
optimum - only unique optimums are returned.
}
\examples{
scoringFunction <- function(x) {
  a <- exp(-(2-x)^2)*1.5
  b <- exp(-(4-x)^2)*2
  c <- exp(-(6-x)^2)*1
  return(list(Score = a+b+c))
}

bounds <- list(x = c(0,8))

Results <- bayesOpt(
    FUN = scoringFunction
  , bounds = bounds
  , initPoints = 3
  , iters.n = 2
  , gsPoints = 10
)
print(getLocalOptimums(Results))
}
