% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_covariate_balance.R
\name{get_covariate_balance}
\alias{get_covariate_balance}
\title{Calculate covariate balance measures for refined and unrefined matched sets}
\usage{
get_covariate_balance(..., panel.data, covariates, include.unrefined = TRUE)
}
\arguments{
\item{...}{one or more PanelMatch objects}

\item{panel.data}{\code{PanelData} object}

\item{covariates}{a character vector, specifying the names of the covariates for which the user is interested in calculating balance.}

\item{include.unrefined}{logical. Indicates whether or not covariate balance measures for unrefined matched sets should be included. If TRUE, the function will return covariate balance results for the PanelMatch configurations provided, as well as a set of balance results that assume all matched controls have equal weight (i.e., the matched sets are unrefined). These results are included in addition to whatever PanelMatch configurations are specified to the function. Note that if you provide a PanelMatch object where no refinement is applied (that is, where \code{refinement.method = "none"}) and set this option to TRUE, then both sets of covariate balance results will be identical. If FALSE, then only balance calculations for the provided PanelMatch specifications are performed and returned.}
}
\value{
A list of matrices, or a list of lists (if the QOI is ATE). The matrices contain the calculated covariate balance levels for each specified covariate for each period. Each element in the list (whether that be a matrix or a sublist) corresponds to a \code{PanelMatch} configuration specified to the function. Results are returned in the order they were provided. Unrefined results are stored as a parallel list object in an attribute called "unrefined.balance.results".
}
\description{
Calculate covariate balance for user specified covariates across matched sets. Balance is assessed by taking the average
of the difference between the values of the specified covariates for the treated unit(s) and the weighted average of
the control units across all matched sets. Results are standardized and are expressed in standard deviations.
Balance is calculated for each period in the specified lag window.
}
\examples{
dem.sub <- dem[dem[, "wbcode2"] <= 100, ]
# create subset of data for simplicity
#add some additional data to data set for demonstration purposes
dem.sub$rdata <- runif(runif(nrow(dem.sub)))
dem.sub.panel <- PanelData(dem.sub, "wbcode2", "year", "dem", "y")
PM.results <- PanelMatch(panel.data = dem.sub.panel, lag = 4, 
                         refinement.method = "ps.match", 
                         match.missing = TRUE, 
                         covs.formula = ~ tradewb + rdata,
                         size.match = 5, qoi = "att",
                         lead = 0:4, 
                         forbid.treatment.reversal = FALSE)
get_covariate_balance(PM.results, panel.data = dem.sub.panel, covariates = c("tradewb", "rdata"))

}
