% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matched_set_obj.R
\name{weights.matched.set}
\alias{weights.matched.set}
\title{Extract the weights of matched control units}
\usage{
\method{weights}{matched.set}(object)
}
\arguments{
\item{object}{matched.set object, extracted using the \code{get.PanelMatch()} method}
}
\value{
list of named vectors. Each list element corresponds to a particular treated observation and contains the matched control units, along with their weights. These correspond to the "weights" attribute, which are calculated in the \code{PanelMatch} refinement process.
}
\description{
Extract the weights of matched control units
}
\examples{
dem.panel <- PanelData(dem, "wbcode2", "year", "dem", "y")
PM.results <- PanelMatch(panel.data = dem.panel, lag = 4,
                        refinement.method = "ps.match",
                        match.missing = TRUE,
                        covs.formula = ~ tradewb,
                        size.match = 5, qoi = "att",
                        lead = 0:4,
                        forbid.treatment.reversal = FALSE)
r1 <- extract(PM.results, qoi = "att")
lt <- weights(r1)
}
