// Generated by rstantools.  Do not edit by hand.

/*
    pandemicLP is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    pandemicLP is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with pandemicLP.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_multiwaves_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_multiwaves");
    reader.add_event(64, 62, "end", "model_multiwaves");
    return reader;
}
#include <stan_meta_header.hpp>
class model_multiwaves
  : public stan::model::model_base_crtp<model_multiwaves> {
private:
        int n;
        std::vector<int> y;
        int pop;
        double p;
public:
    model_multiwaves(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_multiwaves(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_multiwaves_namespace::model_multiwaves";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 9;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            check_greater_or_equal(function__, "n", n, 1);
            current_statement_begin__ = 10;
            validate_non_negative_index("y", "n", n);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(n));
            y = std::vector<int>(n, int(0));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_k_0_max__ = n;
            for (size_t k_0__ = 0; k_0__ < y_k_0_max__; ++k_0__) {
                y[k_0__] = vals_i__[pos__++];
            }
            size_t y_i_0_max__ = n;
            for (size_t i_0__ = 0; i_0__ < y_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "y[i_0__]", y[i_0__], 0);
            }
            current_statement_begin__ = 11;
            context__.validate_dims("data initialization", "pop", "int", context__.to_vec());
            pop = int(0);
            vals_i__ = context__.vals_i("pop");
            pos__ = 0;
            pop = vals_i__[pos__++];
            check_greater_or_equal(function__, "pop", pop, 0);
            current_statement_begin__ = 12;
            context__.validate_dims("data initialization", "p", "double", context__.to_vec());
            p = double(0);
            vals_r__ = context__.vals_r("p");
            pos__ = 0;
            p = vals_r__[pos__++];
            check_greater_or_equal(function__, "p", p, 0);
            check_less_or_equal(function__, "p", p, 1);
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 18;
            num_params_r__ += 1;
            current_statement_begin__ = 19;
            num_params_r__ += 1;
            current_statement_begin__ = 20;
            num_params_r__ += 1;
            current_statement_begin__ = 21;
            num_params_r__ += 1;
            current_statement_begin__ = 22;
            num_params_r__ += 1;
            current_statement_begin__ = 23;
            num_params_r__ += 1;
            current_statement_begin__ = 24;
            num_params_r__ += 1;
            current_statement_begin__ = 25;
            num_params_r__ += 1;
            current_statement_begin__ = 26;
            num_params_r__ += 1;
            current_statement_begin__ = 27;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_multiwaves() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 18;
        if (!(context__.contains_r("b1_1")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable b1_1 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("b1_1");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "b1_1", "double", context__.to_vec());
        double b1_1(0);
        b1_1 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(b1_1);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable b1_1: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 19;
        if (!(context__.contains_r("a1")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable a1 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("a1");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "a1", "double", context__.to_vec());
        double a1(0);
        a1 = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, ((pop * p) * stan::math::exp(b1_1)), a1);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable a1: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 20;
        if (!(context__.contains_r("b1_2")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable b1_2 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("b1_2");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "b1_2", "double", context__.to_vec());
        double b1_2(0);
        b1_2 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(b1_2);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable b1_2: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 21;
        if (!(context__.contains_r("a2")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable a2 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("a2");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "a2", "double", context__.to_vec());
        double a2(0);
        a2 = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, ((pop * p) * stan::math::exp(b1_2)), a2);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable a2: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 22;
        if (!(context__.contains_r("alpha1")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha1 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha1");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "alpha1", "double", context__.to_vec());
        double alpha1(0);
        alpha1 = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, alpha1);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha1: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 23;
        if (!(context__.contains_r("alpha2")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha2 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha2");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "alpha2", "double", context__.to_vec());
        double alpha2(0);
        alpha2 = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, alpha2);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha2: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 24;
        if (!(context__.contains_r("delta1")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable delta1 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("delta1");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "delta1", "double", context__.to_vec());
        double delta1(0);
        delta1 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(delta1);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable delta1: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 25;
        if (!(context__.contains_r("delta2")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable delta2 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("delta2");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "delta2", "double", context__.to_vec());
        double delta2(0);
        delta2 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(delta2);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable delta2: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 26;
        if (!(context__.contains_r("c1")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable c1 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("c1");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "c1", "double", context__.to_vec());
        double c1(0);
        c1 = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, c1);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable c1: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 27;
        if (!(context__.contains_r("c2")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable c2 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("c2");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "c2", "double", context__.to_vec());
        double c2(0);
        c2 = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, c2);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable c2: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 18;
            local_scalar_t__ b1_1;
            (void) b1_1;  // dummy to suppress unused var warning
            if (jacobian__)
                b1_1 = in__.scalar_constrain(lp__);
            else
                b1_1 = in__.scalar_constrain();
            current_statement_begin__ = 19;
            local_scalar_t__ a1;
            (void) a1;  // dummy to suppress unused var warning
            if (jacobian__)
                a1 = in__.scalar_lub_constrain(0, ((pop * p) * stan::math::exp(b1_1)), lp__);
            else
                a1 = in__.scalar_lub_constrain(0, ((pop * p) * stan::math::exp(b1_1)));
            current_statement_begin__ = 20;
            local_scalar_t__ b1_2;
            (void) b1_2;  // dummy to suppress unused var warning
            if (jacobian__)
                b1_2 = in__.scalar_constrain(lp__);
            else
                b1_2 = in__.scalar_constrain();
            current_statement_begin__ = 21;
            local_scalar_t__ a2;
            (void) a2;  // dummy to suppress unused var warning
            if (jacobian__)
                a2 = in__.scalar_lub_constrain(0, ((pop * p) * stan::math::exp(b1_2)), lp__);
            else
                a2 = in__.scalar_lub_constrain(0, ((pop * p) * stan::math::exp(b1_2)));
            current_statement_begin__ = 22;
            local_scalar_t__ alpha1;
            (void) alpha1;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha1 = in__.scalar_lb_constrain(0, lp__);
            else
                alpha1 = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 23;
            local_scalar_t__ alpha2;
            (void) alpha2;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha2 = in__.scalar_lb_constrain(0, lp__);
            else
                alpha2 = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 24;
            local_scalar_t__ delta1;
            (void) delta1;  // dummy to suppress unused var warning
            if (jacobian__)
                delta1 = in__.scalar_constrain(lp__);
            else
                delta1 = in__.scalar_constrain();
            current_statement_begin__ = 25;
            local_scalar_t__ delta2;
            (void) delta2;  // dummy to suppress unused var warning
            if (jacobian__)
                delta2 = in__.scalar_constrain(lp__);
            else
                delta2 = in__.scalar_constrain();
            current_statement_begin__ = 26;
            local_scalar_t__ c1;
            (void) c1;  // dummy to suppress unused var warning
            if (jacobian__)
                c1 = in__.scalar_lb_constrain(0, lp__);
            else
                c1 = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 27;
            local_scalar_t__ c2;
            (void) c2;  // dummy to suppress unused var warning
            if (jacobian__)
                c2 = in__.scalar_lb_constrain(0, lp__);
            else
                c2 = in__.scalar_lb_constrain(0);
            // transformed parameters
            current_statement_begin__ = 32;
            local_scalar_t__ b1;
            (void) b1;  // dummy to suppress unused var warning
            stan::math::initialize(b1, DUMMY_VAR__);
            stan::math::fill(b1, DUMMY_VAR__);
            stan::math::assign(b1,stan::math::exp(b1_1));
            current_statement_begin__ = 33;
            local_scalar_t__ b2;
            (void) b2;  // dummy to suppress unused var warning
            stan::math::initialize(b2, DUMMY_VAR__);
            stan::math::fill(b2, DUMMY_VAR__);
            stan::math::assign(b2,stan::math::exp(b1_2));
            current_statement_begin__ = 34;
            validate_non_negative_index("mu1", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu1(n);
            stan::math::initialize(mu1, DUMMY_VAR__);
            stan::math::fill(mu1, DUMMY_VAR__);
            current_statement_begin__ = 35;
            validate_non_negative_index("mu2", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu2(n);
            stan::math::initialize(mu2, DUMMY_VAR__);
            stan::math::fill(mu2, DUMMY_VAR__);
            current_statement_begin__ = 36;
            validate_non_negative_index("mu", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu(n);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 38;
            for (int t = 1; t <= n; ++t) {
                current_statement_begin__ = 39;
                stan::model::assign(mu1, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            stan::math::exp((((stan::math::log(a1) + stan::math::log(c1)) - (c1 * t)) - (2 * stan::math::log((b1 + stan::math::exp((-(c1) * t))))))), 
                            "assigning variable mu1");
                current_statement_begin__ = 40;
                stan::model::assign(mu2, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            stan::math::exp((((stan::math::log(a2) + stan::math::log(c2)) - (c2 * t)) - (2 * stan::math::log((b2 + stan::math::exp((-(c2) * t))))))), 
                            "assigning variable mu2");
                current_statement_begin__ = 41;
                stan::model::assign(mu, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            ((normal_cdf((alpha1 * (t - delta1)), 0, 1) * get_base1(mu1, t, "mu1", 1)) + (normal_cdf((alpha2 * (t - delta2)), 0, 1) * get_base1(mu2, t, "mu2", 1))), 
                            "assigning variable mu");
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 32;
            if (stan::math::is_uninitialized(b1)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: b1";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable b1: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            check_greater_or_equal(function__, "b1", b1, 0);
            current_statement_begin__ = 33;
            if (stan::math::is_uninitialized(b2)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: b2";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable b2: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            check_greater_or_equal(function__, "b2", b2, 0);
            current_statement_begin__ = 34;
            size_t mu1_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu1_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(mu1(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: mu1" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu1: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "mu1", mu1, 0);
            current_statement_begin__ = 35;
            size_t mu2_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu2_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(mu2(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: mu2" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu2: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "mu2", mu2, 0);
            current_statement_begin__ = 36;
            size_t mu_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(mu(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: mu" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "mu", mu, 0);
            // model body
            current_statement_begin__ = 49;
            lp_accum__.add(poisson_log<propto__>(y, mu));
            current_statement_begin__ = 52;
            lp_accum__.add(gamma_log<propto__>(a1, 0.1, 0.1));
            current_statement_begin__ = 53;
            lp_accum__.add(gamma_log<propto__>(a2, 0.1, 0.1));
            current_statement_begin__ = 54;
            lp_accum__.add(gamma_log<propto__>(c1, 2, 9));
            current_statement_begin__ = 55;
            lp_accum__.add(gamma_log<propto__>(c2, 2, 9));
            current_statement_begin__ = 56;
            lp_accum__.add(gamma_log<propto__>(alpha1, 0.01, 0.01));
            current_statement_begin__ = 57;
            lp_accum__.add(gamma_log<propto__>(alpha2, 0.01, 0.01));
            current_statement_begin__ = 58;
            lp_accum__.add(normal_log<propto__>(delta1, 0, 100));
            current_statement_begin__ = 59;
            lp_accum__.add(normal_log<propto__>(delta2, 0, 100));
            current_statement_begin__ = 60;
            lp_accum__.add(normal_log<propto__>(b1_1, 0, stan::math::sqrt(20)));
            current_statement_begin__ = 61;
            lp_accum__.add(normal_log<propto__>(b1_2, 0, stan::math::sqrt(20)));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("b1_1");
        names__.push_back("a1");
        names__.push_back("b1_2");
        names__.push_back("a2");
        names__.push_back("alpha1");
        names__.push_back("alpha2");
        names__.push_back("delta1");
        names__.push_back("delta2");
        names__.push_back("c1");
        names__.push_back("c2");
        names__.push_back("b1");
        names__.push_back("b2");
        names__.push_back("mu1");
        names__.push_back("mu2");
        names__.push_back("mu");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_multiwaves_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double b1_1 = in__.scalar_constrain();
        vars__.push_back(b1_1);
        double a1 = in__.scalar_lub_constrain(0, ((pop * p) * stan::math::exp(b1_1)));
        vars__.push_back(a1);
        double b1_2 = in__.scalar_constrain();
        vars__.push_back(b1_2);
        double a2 = in__.scalar_lub_constrain(0, ((pop * p) * stan::math::exp(b1_2)));
        vars__.push_back(a2);
        double alpha1 = in__.scalar_lb_constrain(0);
        vars__.push_back(alpha1);
        double alpha2 = in__.scalar_lb_constrain(0);
        vars__.push_back(alpha2);
        double delta1 = in__.scalar_constrain();
        vars__.push_back(delta1);
        double delta2 = in__.scalar_constrain();
        vars__.push_back(delta2);
        double c1 = in__.scalar_lb_constrain(0);
        vars__.push_back(c1);
        double c2 = in__.scalar_lb_constrain(0);
        vars__.push_back(c2);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 32;
            double b1;
            (void) b1;  // dummy to suppress unused var warning
            stan::math::initialize(b1, DUMMY_VAR__);
            stan::math::fill(b1, DUMMY_VAR__);
            stan::math::assign(b1,stan::math::exp(b1_1));
            current_statement_begin__ = 33;
            double b2;
            (void) b2;  // dummy to suppress unused var warning
            stan::math::initialize(b2, DUMMY_VAR__);
            stan::math::fill(b2, DUMMY_VAR__);
            stan::math::assign(b2,stan::math::exp(b1_2));
            current_statement_begin__ = 34;
            validate_non_negative_index("mu1", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> mu1(n);
            stan::math::initialize(mu1, DUMMY_VAR__);
            stan::math::fill(mu1, DUMMY_VAR__);
            current_statement_begin__ = 35;
            validate_non_negative_index("mu2", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> mu2(n);
            stan::math::initialize(mu2, DUMMY_VAR__);
            stan::math::fill(mu2, DUMMY_VAR__);
            current_statement_begin__ = 36;
            validate_non_negative_index("mu", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> mu(n);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 38;
            for (int t = 1; t <= n; ++t) {
                current_statement_begin__ = 39;
                stan::model::assign(mu1, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            stan::math::exp((((stan::math::log(a1) + stan::math::log(c1)) - (c1 * t)) - (2 * stan::math::log((b1 + stan::math::exp((-(c1) * t))))))), 
                            "assigning variable mu1");
                current_statement_begin__ = 40;
                stan::model::assign(mu2, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            stan::math::exp((((stan::math::log(a2) + stan::math::log(c2)) - (c2 * t)) - (2 * stan::math::log((b2 + stan::math::exp((-(c2) * t))))))), 
                            "assigning variable mu2");
                current_statement_begin__ = 41;
                stan::model::assign(mu, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            ((normal_cdf((alpha1 * (t - delta1)), 0, 1) * get_base1(mu1, t, "mu1", 1)) + (normal_cdf((alpha2 * (t - delta2)), 0, 1) * get_base1(mu2, t, "mu2", 1))), 
                            "assigning variable mu");
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 32;
            check_greater_or_equal(function__, "b1", b1, 0);
            current_statement_begin__ = 33;
            check_greater_or_equal(function__, "b2", b2, 0);
            current_statement_begin__ = 34;
            check_greater_or_equal(function__, "mu1", mu1, 0);
            current_statement_begin__ = 35;
            check_greater_or_equal(function__, "mu2", mu2, 0);
            current_statement_begin__ = 36;
            check_greater_or_equal(function__, "mu", mu, 0);
            // write transformed parameters
            if (include_tparams__) {
                vars__.push_back(b1);
                vars__.push_back(b2);
                size_t mu1_j_1_max__ = n;
                for (size_t j_1__ = 0; j_1__ < mu1_j_1_max__; ++j_1__) {
                    vars__.push_back(mu1(j_1__));
                }
                size_t mu2_j_1_max__ = n;
                for (size_t j_1__ = 0; j_1__ < mu2_j_1_max__; ++j_1__) {
                    vars__.push_back(mu2(j_1__));
                }
                size_t mu_j_1_max__ = n;
                for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                    vars__.push_back(mu(j_1__));
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_multiwaves";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "b1_1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "a1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "b1_2";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "a2";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha2";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta2";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "c1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "c2";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b1";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "b2";
            param_names__.push_back(param_name_stream__.str());
            size_t mu1_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t mu2_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu2_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu2" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t mu_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "b1_1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "a1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "b1_2";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "a2";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha2";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta2";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "c1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "c2";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b1";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "b2";
            param_names__.push_back(param_name_stream__.str());
            size_t mu1_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t mu2_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu2_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu2" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t mu_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_multiwaves_namespace::model_multiwaves stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
