% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_timeseriesPlot.R
\name{monitor_timeseriesPlot}
\alias{monitor_timeseriesPlot}
\title{Create Timeseries Plot}
\usage{
monitor_timeseriesPlot(ws_monitor, monitorID = NULL, tlim = NULL,
  localTime = TRUE, style = NULL, shadedNight = FALSE, add = FALSE,
  gridPos = "", gridCol = "black", gridLwd = 1, gridLty = "solid",
  dayLwd = 0, hourLwd = 0, hourInterval = 6, ...)
}
\arguments{
\item{ws_monitor}{\emph{ws_monitor} object.}

\item{monitorID}{Monitor ID for one or more monitor in the ws_monitor object.}

\item{tlim}{Optional vector with start and end times (integer or character
representing YYYYMMDD[HH]).}

\item{localTime}{Logical specifying whether \code{tlim} is in local time or
UTC.}

\item{style}{Custom styling, one of \code{"aqidots"}.}

\item{shadedNight}{Add nighttime shading.}

\item{add}{Logical specifying whether to add to the current plot.}

\item{gridPos}{Position of grid lines either "over", "under" ("" for no grid
lines).}

\item{gridCol}{Grid line color.}

\item{gridLwd}{Grid line width.}

\item{gridLty}{Grid line type.}

\item{dayLwd}{Day marker line width.}

\item{hourLwd}{Hour marker line width.}

\item{hourInterval}{Interval for grid (max = 12).}

\item{...}{Additional arguments to be passed to \code{points()}.}
}
\description{
Creates a time series plot of PM2.5 data from a \emph{ws_monitor} object (see
note below). Optional arguments color code by AQI index, add shading to
indicate nighttime, and adjust the time display (local vs. UTC).

When a named \code{style} is used, some graphical parameters will be
overridden. Available styles include:

\itemize{
  \item{\code{aqidots}}{-- hourly values are individually colored by 24-hr
    AQI levels}
  \item{\code{gnats}}{-- semi-transparent dots like a cloud of gnats}
}
}
\note{
Remember that a \emph{ws_monitor} object can contain data from more than one
monitor, and thus, this function may produce a time series of data from
multiple monitors. To plot a time series of an individual monitor's data,
specify a single \code{monitorID}.
}
\examples{
N_M <- Northwest_Megafires
# monitor_leaflet(N_M) # to identify Spokane monitorIDs
Spokane <- monitor_subsetBy(
  N_M,
  stringr::str_detect(N_M$meta$monitorID, "^53063")
)

monitor_timeseriesPlot(Spokane, style = "gnats")
title("Spokane PM2.5 values, 2015")
monitor_timeseriesPlot(
  Spokane,
  tlim = c(20150801, 20150831),
  style = "aqidots",
  pch = 16
)
addAQILegend()
title("Spokane PM2.5 values, August 2015")
monitor_timeseriesPlot(
  Spokane,
  tlim = c(20150821, 20150828),
  shadedNight = TRUE,
  style = "gnats"
)
abline(h = AQI$breaks_24, col = AQI$colors, lwd = 2)
addAQILegend()
title("Spokane PM2.5 values, August 2015")
}
\keyword{ws_monitor}
