% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitorGoogleMap.R
\name{monitorGoogleMap}
\alias{monitorGoogleMap}
\title{Create a Google Map of ws_monitor Object}
\usage{
monitorGoogleMap(ws_monitor, slice = get("max"),
  breaks = AQI$breaks_24, colors = AQI$colors, width = 640,
  height = 640, centerLon = NULL, centerLat = NULL, zoom = NULL,
  maptype = "roadmap", grayscale = FALSE, map = NULL, ...)
}
\arguments{
\item{ws_monitor}{\emph{ws_monitor} object}

\item{slice}{either a time index or a function used to collapse the time axis -- defautls to \code{get('max')}}

\item{breaks}{set of breaks used to assign colors}

\item{colors}{a set of colors for different levels of air quality data determined by \code{breaks}}

\item{width}{width of image, in pixels}

\item{height}{height of image, in pixels}

\item{centerLon}{map center longitude}

\item{centerLat}{map center latitude}

\item{zoom}{map zoom level}

\item{maptype}{map type}

\item{grayscale}{logical, if TRUE the colored map tile is rendered into a black & white image}

\item{map}{optional map object returned from \code{monitorGoogleMap(})}

\item{...}{arguments passed on to \code{RgoogleMaps::PlotOnStaticMap()} (\emph{e.g.} destfile, cex, pch, etc.)}
}
\value{
A \emph{MyMap} RgoogleMaps map object object that can serve as a base plot.
}
\description{
Creates a Google map of a \emph{ws_monitor} object using the \pkg{RgoogleMaps} package.

If \code{centerLon}, \code{centerMap} or \code{zoom} are not specified, appropriate values
will be calcualted using data from the \code{ws_monitor$meta} dataframe.
}
\examples{
\dontrun{
N_M <- Northwest_Megafires
# monitorLeaflet(N_M) # to identify Spokane monitorIDs
Spokane <- monitor_subsetBy(N_M, stringr::str_detect(N_M$meta$monitorID,'^53063'))
Spokane <- monitor_subset(Spokane, tlim=c(20150815, 20150831))
monitorGoogleMap(Spokane)
}
}
\keyword{ws_monitor}
