% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_fun.R
\name{plr_var}
\alias{plr_var}
\title{PLR linear model uncertainty}
\usage{
plr_var(mod, per_year)
}
\arguments{
\item{mod}{linear model}

\item{per_year}{number of data points in a given year baesd on which time scale was selected}
}
\value{
Returns standard deviation of PLR value
}
\description{
This function returns the standard deviation of a PLR calculated from a linear model
}
\examples{
# build var_list
var_list <- plr_build_var_list(time_var = "timestamp",
                               power_var = "power",
                               irrad_var = "g_poa",
                               temp_var = "mod_temp",
                               wind_var = NA)
# Clean Data
test_dfc <- plr_cleaning(test_df, var_list, irrad_thresh = 100,
                         low_power_thresh = 0.01, high_power_cutoff = NA)
                         
# Perform the power predictive modeling step
test_xbx_wbw_res <- plr_xbx_model(test_dfc, var_list, by = "week",
                                  data_cutoff = 30, predict_data = NULL)

# obain standard deviation from model
mod <- lm(power_var ~ time_var, data = test_xbx_wbw_res)
plr_sd <- plr_var(mod, per_year = 52)

}
