% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FS3analysis.R
\name{FS3analysis}
\alias{FS3analysis}
\title{Fritz-Schlunder Three Parameter Non-Linear Analysis}
\usage{
FS3analysis(Ce, Qe)
}
\arguments{
\item{Ce}{the numerical value for equilibrium capacity}

\item{Qe}{the numerical value for the adsorbed capacity}
}
\value{
the nonlinear regression, parameters for Fritz-Schlunder three Parameter
isotherm, and model error analysis
}
\description{
The Fritz-Schlunder isotherm model is an empirical expression that
can fit over an extensive range of experimental results as a result of the huge
number of coefficients in their adsorption isotherm.
}
\examples{
Ce <- c(0.9613, 1.0895, 1.5378, 1.9862, 3.3314, 7.8153, 11.4024, 15.8862)
Qe <- c(2.5546, 4.4150, 5.8558, 7.1387, 8.8092, 13.1921, 15.7966, 18.4483)
FS3analysis(Ce,Qe)
}
\references{
Fritz, W., and Schluender, E. U. (1974) <doi:z10.1016/0009-2509(74)80128-4> Simultaneous adsorption
equilibria of organic solutes in dilute aqueous solutions on activated carbon.
Chemical Engineering Science, 29(5), 1279-1282.
}
\author{
Jemimah Christine L. Mesias

Chester C. Deocaris
}
