% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_plots.R
\name{plot_UncalibratedMSErr}
\alias{plot_UncalibratedMSErr}
\title{A boxplot of uncalibrated mass errors for each Raw file.}
\usage{
plot_UncalibratedMSErr(data, MQBug_raw_files, stats, y_lim, extra_limit,
  title_sub)
}
\arguments{
\item{data}{A data.frame with columns 'fc.raw.file', 'uncalibrated.mass.error..ppm.'}

\item{MQBug_raw_files}{List of Raw files with invalid calibration values}

\item{stats}{A data.frame with columns 'fc.raw.file', 'sd', 'outOfCal'}

\item{y_lim}{Range of y-axis}

\item{extra_limit}{Position where a v-line is plotted (for visual guidance)}

\item{title_sub}{Subtitle}
}
\value{
GGplot object
}
\description{
Boxes are optionally colored to indicate that a MQ bug was detected or 
if PTXQC detected a too narrow search window.
}
\examples{
  n = c(150, 1000, 1000, 1000)
  data = data.frame(fc.raw.file = repEach(letters[4:1], n),
                    uncalibrated.mass.error..ppm. = c(rnorm(n[1], 13, 2.4),
                                                      rnorm(n[2], 4, 0.5),
                                                      rnorm(n[3], 3, 0.7),
                                                      rnorm(n[4], 4.5, 0.8)))
  stats = data.frame(fc.raw.file = letters[4:1],
                     sd_uncal = c(2.4, 0.5, 0.7, 0.8),
                     outOfCal = c(TRUE, FALSE, FALSE, FALSE))           
  plot_UncalibratedMSErr(data, MQBug_raw_files = letters[1],
                         stats, y_lim = c(-20,20), 15, "subtitle")

}
