% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FPSSM.R
\name{FPSSM}
\alias{FPSSM}
\title{D-FPSSM and SF-PSSM feature vectors}
\usage{
FPSSM(pssm_name, hk)
}
\arguments{
\item{pssm_name}{name of PSSM Matrix file}

\item{hk}{a parameter that indicates which amino acid alphabet must be used}
}
\value{
two feature vectors of different length which is used in later steps.
}
\description{
This function produces list of two feature vectors named D-FPSSM and S-FPSSM
which then used by FPSSM2 function to construct feature vector of length 100 for each pair of
proteins which then used for protein-protein interaction prediction in each dataset.
}
\examples{
q<-FPSSM(system.file("extdata","C7GQS7.txt.pssm",package="PSSMCOOL"),8)

}
\references{
Zahiri, J., et al. (2013) PPIevo: protein-protein interaction prediction from PSSM based
evolutionary information, Genomics, 102, 237-242.
}
