% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kiderafactor.R
\name{kiderafactor}
\alias{kiderafactor}
\title{kiderafactor feature}
\usage{
kiderafactor(pssm_name, v = NULL)
}
\arguments{
\item{pssm_name}{name of PSSM Matrix file}

\item{v}{vector of amino acids positions which we want to produce feature vector for them.}
}
\value{
matrix of feature vectors
}
\description{
For product of this feature vector similar to smoothed_PSSM feature, firstly PSSM Matrix is
smoothed by appending zero vectors to its head and tail and utilizing sliding window of size odd, then this
smoothed PSSM Matrix is condensed by the Kidera factors to produce feature vector for each residue.
}
\examples{
w<-kiderafactor(system.file("extdata", "C7GQS7.txt.pssm", package="PSSMCOOL"),c(2,3,8,9))
}
\references{
C. Fang, T. Noguchi, H. J. I. j. o. d. m. Yamana, and bioinformatics, "Condensing position-specific scoring
matrixs by the Kidera factors for ligand-binding site prediction," vol. 12, no. 1, pp. 70-84, 2015.
}
\seealso{
\code{\link{smoothed_PSSM}}
}
