% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AB_PSSM.R
\name{AB_PSSM}
\alias{AB_PSSM}
\title{AB-PSSM and RPM-PSSM feature vector}
\usage{
AB_PSSM(pssm_name)
}
\arguments{
\item{pssm_name}{name of PSSM Matrix file}
}
\value{
two feature vectors AB-PSSM and RPM-PSSM each of length 400
}
\description{
This feature consists of two types of feature vectors. at first, each protein sequence is divided into
20 equal parts, each of which is called a block, and in each block the row vectors of the PSSM matrix related
to that block are added together and The resulting final vector is divided by the length of that block, which is
5% of the total length of the protein.
Finally, by placing these 20 vectors side by side, the first feature vector of length 400 is obtained. The second feature
for each amino acid in each column is the average of the positive numbers in that column and for each block, and these 20
numbers, corresponding to 20 blocks, are placed next to each other, and therefore For each of the 20 types of amino acids,
a vector of length 20 is obtained, and by placing these together, the vector of the second feature, length 400, is obtained.
}
\examples{
zz<- AB_PSSM(system.file("extdata","C7GRQ3.txt.pssm",package="PSSMCOOL"))
}
\references{
Jeong, J.C., Lin, X. and Chen, X.W. (2011) On position-specific scoring matrix for protein function prediction
, IEEE/ACM transactions on computational biology and bioinformatics / IEEE, ACM, 8, 308-315.
}
