% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psf_plot.R
\name{psf_plot}
\alias{psf_plot}
\title{Plot actual and forecasted values of an univariate time series}
\usage{
psf_plot(data, predictions, cycle = 24, ...)
}
\arguments{
\item{data}{Input univariate time series (in either time series (ts) or vector format). All values should be numeric.}

\item{predictions}{A vector with already forecasted values.}

\item{cycle}{The number of values that conform a cycle in the time series (e.g. 24 hours per day, 12 month per year, and so on). Only used when input data is not in time series (ts) format.}

\item{\dots}{Additional graphical parameters given to plot function.}
}
\description{
Takes an univariate time series and a vector with forecasted values.
}
\examples{
## Forecast the next 12 values of the univariate time series: nottem (package:datasets).
res <- psf(nottem, 12)

## Plot forecasted values from PSF.
psf_plot(nottem, res$predictions)
}

