% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PROJ-package.R
\docType{package}
\name{PROJ-package}
\alias{PROJ}
\alias{PROJ-package}
\title{PROJ: Generic Coordinate System Transformations Using 'PROJ'}
\description{
A wrapper around the generic coordinate transformation software 'PROJ' that transforms coordinates from one coordinate reference system ('CRS') to another. This includes cartographic projections as well as geodetic transformations. The intention is for this package to be used by user-packages such as 'reproj', and that the older 'PROJ.4' and version 5 pathways be provided by the 'proj4' package.

The goal of PROJ is to provide generic coordinate system transformations in R
without requiring bespoke formats for storing basic data.
}
\section{I. Functions}{

\tabular{ll}{
\code{\link{ok_proj6}} determine if PROJ version >=6 is available
\code{\link{proj_trans}} a light wrapper around the underlying transformation functionality of PROJ version 6 (or higher)
\code{\link{proj_crs_text}} generate PROJ crs strings from input
\code{\link{proj_version}} report PROJ lib version if available \emph{and} >= 6.3.1
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/hypertidy/PROJ}
  \item Report bugs at \url{https://github.com/hypertidy/PROJ/issues}
}

}
\author{
\strong{Maintainer}: Michael D. Sumner \email{mdsumner@gmail.com} (\href{https://orcid.org/0000-0002-2471-7511}{ORCID})

Other contributors:
\itemize{
  \item Jeroen Ooms (provided PROJ library support on Windows, and assistance with Windows configuration) [contributor]
  \item Simon Urbanek (wrote original code versions for PROJ version 6) [copyright holder, contributor]
  \item Dewey Dunnington (key code contributions) [contributor]
}

}
\keyword{internal}
