% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predictPPtreeclass.R
\name{predict.PPtreeclass}
\alias{predict}
\alias{predict.PPtreeclass}
\title{predict PPtree}
\usage{
\method{predict}{PPtreeclass}(object, newdata = NULL, Rule = 1, ...)
}
\arguments{
\item{object}{a fitted object of class inheriting from "PP.Tree.class"}

\item{newdata}{the test dataset}

\item{Rule}{split rule 1: mean of two group means
2: weighted mean of two group means
   - weight with group size
3: weighted mean of two group means
   - weight with group sd
4: weighted mean of two group means
   - weight with group se
5: mean of two group medians
6: weighted mean of two group medians
   - weight with group size
7: weighted mean of two group median
   - weight with group IQR
8: weighted mean of two group median
   - weight with group IQR and size}

\item{...}{arguments to be passed to methods}
}
\description{
predict projection pursuit classification tree
}
\details{
Predict class for the test set with the fitted projection pursuit
classification tree and calculate prediction error.
}
\examples{
data(iris)
n <- nrow(iris)
tot <- c(1:n)
n.train <- round(n*0.9)
train <- sample(tot,n.train)
test <- tot[-train]
Tree.result <- PP.Tree.class(iris[train,5],iris[train,1:4],"LDA")
predict(Tree.result)
}
\references{
Lee, YD, Cook, D., Park JW, and Lee, EK(2013)
PPtree: Projection pursuit classification tree,
Electronic Journal of Statistics, 7:1369-1386.
}
\keyword{tree}

