% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chain.R
\name{chain}
\alias{chain}
\title{Generate a complete order from a vector of elements' labels}
\usage{
chain(elements)
}
\arguments{
\item{elements}{a vector of characters listing the elements' labels.}
}
\value{
an S4 object of class \code{Rcpp_POSet}.
}
\description{
The function produces a complete order from the vector of elements' labels \code{elements}.
If \code{elements} is a numeric vector, it is first coerced to a character vector.

A complete order is a poset where all of the elements are comparable; the order of the labels in \code{elements} defines their position in the chain, from bottom to top.
}
\examples{
chain(LETTERS[1:5])
}
\seealso{
function \code{\link[POSetR]{poset}} for more details and to create a generic poset and function \code{\link[POSetR]{antiChain}} to create an anti-chain.
}
