% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p.adjust.POST.R
\name{p.adjust}
\alias{p.adjust}
\alias{p.adjust.POST}
\title{Adjust P-values for Multiple Comparisons}
\usage{
p.adjust(p, ...)

\method{p.adjust}{POST}(p, ..., method = p.adjust.methods, n = length(x = p), alpha = 0.05)
}
\arguments{
\item{p}{An object of class POST. The value object returned by post().}

\item{...}{Ignored.}

\item{method}{A character vector object. One or more correction methods.
must be one or more from \{"holm", "hochberg", "hommel", "bonferroni", "BH", "BY",
"fdr", "none", "TSBH"\}.}

\item{n}{number of comparisons, must be at least ‘length(p)’; 
Per ?stats::p.adjust -- only set this (to non-default) when you know 
what you are doing!}

\item{alpha}{A numeric object. A nominal type I error rate, or a vector of 
error rates, used for estimating the number of true null hypotheses in 
the two-stage Benjamini & Hochberg procedure ("TSBH"). Default is 0.05.
NOTE: This definition does not conform to stats::p.adjust.}
}
\value{
A list, the contents of which will depend on the type of analysis.
  If a tree object was provided for the analysis, the list will contain
  \item{adjPOST}{A matrix object. The adjusted p-values for the POST p-values.
    The rows correspond to each OTU; the
    columns to each specified adjustment method.}
  \item{adjSO}{A matrix object. The adjusted p-values for the single OTU p-values.
    The rows correspond to each OTU; the
    columns to each specified adjustment method.}
 If no tree object was provided, only adjSO as described above will be returned.
}
\description{
Given a set of p-values, returns p-values adjusted using one of
 several methods.

Given an object of class POST, returns the POST and SO p-values
  adjusted using the specified method(s).
}
\details{
Extends the p.adjust() method of stats and incorporates the TSBH
 method available through multtest::mt.raw2adjp.
}
\examples{

data("POSTmData")

y <- as.integer(x = metadata[,"GC"] == "BV")
X <- metadata[,"mRace"]

result <- post(y = y, 
               X = X, 
               OTU = otu[,1:20], 
               tree = otutree,
               cValues = seq(0,0.05,by=0.01))

 p.adjust(p = result, method = c("BH","BY"))

}
