% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computePOD.R
\name{computePOD}
\alias{computePOD}
\title{Compute the Probability Of Detection (POD)}
\usage{
computePOD(x, lambda = 1, b = 1)
}
\arguments{
\item{x}{Nominal DNA concentrations (numeric vector)}

\item{lambda}{The fraction of detected DNA fragments (numeric scalar)}

\item{b}{correction parameter (numeric scalar)}
}
\value{
The POD function as described in Uhlig et al., 2015
}
\description{
Compute the Probability Of Detection (POD) in qualitative PCR experiments carried out by a single laboratory.
}
\examples{
# the optimal POD
computePOD(exp(seq(1, 10, 1)), 1, 1)
# some other POD
computePOD(exp(seq(1, 10, 1)), 0.5, 1.29)
}
\references{
Uhlig et al. Accred Qual Assur (2015) 20: 75. https://doi.org/10.1007/s00769-015-1112-9
}
