% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form.R
\name{form}
\alias{form}
\title{Function to generate activity data frame for penalized multi-band learning}
\usage{
form(lis, maxday = 14, id = NULL)
}
\arguments{
\item{lis}{the list of activity data, with each element corresponding to the observation by one individual and the name of each element coresponding to the individual id. Specifically, each element is a \code{nob} by \code{nday} matrix, where each column is an observation by day.}

\item{maxday}{the maximal number of days per individual in the observation, used to check the data format. The default is 14.}

\item{id}{a vector of id names corresponding to the \code{lis} activity data.}
}
\value{
The activity data frame with 3 columns: ID, IDday, and activity.
}
\description{
This function generates the data frame necessary for further penalized multi-band learning.
}
\examples{
data(lis3)
pa3 <- form(lis3)

}
\seealso{
\code{\link{bandSelect}}
}
\keyword{trelliscope}
