\name{posthoc.kruskal.dunn.test}
\alias{posthoc.kruskal.dunn.test}
\alias{posthoc.kruskal.dunn.test.default}
\alias{posthoc.kruskal.dunn.test.formula}


%- Also NEED an '\alias' for EACH other topic documented here.
\title{
%%  ~~function to do ... ~~
Pairwise Test for Multiple Comparisons of Mean Rank Sums (Dunn's-Test)
}
\description{
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
Calculate pairwise multiple comparisons between group levels according to Dunn.
}
\usage{
posthoc.kruskal.dunn.test(x, \dots)

\method{posthoc.kruskal.dunn.test}{default}( x, g, p.adjust.method =
p.adjust.methods, \dots)

\method{posthoc.kruskal.dunn.test}{formula}(formula, data, subset,
na.action, p.adjust.method = p.adjust.methods, \dots)

}
%- maybe also 'usage' for other objects documented here.
\arguments{
%%  \item{x}{
%%     ~~Describe \code{x} here~~
%%   response vector. 
%%}
%%  \item{g}{
%%     ~~Describe \code{g} here~~
%%  grouping vector or factor.
%}
  \item{x}{a numeric vector of data values, or a list of numeric data
    vectors.}
  \item{g}{a vector or factor object giving the group for the
    corresponding elements of \code{x}.  Ignored if \code{x} is a
    list.}
  \item{formula}{a formula of the form \code{response ~ group} where
    \code{response} gives the data values and \code{group} a vector or
    factor of the corresponding groups.} 
  \item{data}{an optional matrix or data frame (or similar: see
    \code{\link{model.frame}}) containing the variables in the
    formula \code{formula}.  By default the variables are taken from
    \code{environment(formula)}.}
  \item{subset}{an optional vector specifying a subset of observations
    to be used.}
  \item{na.action}{a function which indicates what should happen when
    the data contain \code{NA}s.  Defaults to
    \code{getOption("na.action")}.}
  \item{p.adjust.method}{Method for adjusting p values (see \code{\link{p.adjust}}).}
  \item{\dots}{further arguments to be passed to or from methods.}
}
\details{
%%  ~~ If necessary, more details than the description above ~~
For one-factorial designs with samples that do not meet the assumptions for one-way-ANOVA and subsequent post-hoc tests, the Kruskal-Wallis-Test  \code{\link{kruskal.test}} can be employed that is also referred to as the Kruskal–Wallis one-way analysis of variance by ranks. Provided that significant differences were detected by this global test, one may be interested in applying post-hoc tests according to Dunn for pairwise multiple comparisons of the ranked data.

See the vignette for details.
}

\value{
Object of class \code{"pairwise.htest"}
%%  ~Describe the value returned
%%  If it is a LIST, use
  \item{method }{The applied method.}
  \item{data.name}{The name of the data.}
  \item{p.value}{The p-value of the standard normal distribution.}
  \item{statistic}{The estimated quantile of the standard normal distribution.}
  \item{p.adjust.method}{The applied method for p-value adjustment.}
%% ...
}
\references{
%% ~put references to the literature/web site here ~

O.J. Dunn (1964). Multiple comparisons using rank sums. \emph{Technometrics}, 6, 241-252. 

S. A. Glantz (2012), \emph{Primer of Biostatistics}. New York: McGraw Hill.
}
\author{
%%  ~~who you are~~
Thorsten Pohlert
}
\note{
%%  ~~further notes~~
 A tie correction will be employed according to Glantz (2012).
}

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
\code{\link{kruskal.test}},
\code{\link{friedman.test}},
\code{\link{posthoc.friedman.nemenyi.test}},
\code{\link{pnorm}},
\code{\link{p.adjust}}
}
\examples{
##
require(stats) 
data(InsectSprays)
attach(InsectSprays)
kruskal.test(count, spray)
posthoc.kruskal.dunn.test(count, spray, "bonferroni")
detach(InsectSprays)
rm(InsectSprays)
## Formula Interface
posthoc.kruskal.dunn.test(count ~ spray, data = InsectSprays, p.adjust="bonf")
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~htest }
%\keyword{ ~htest }% __ONLY ONE__ keyword per line
