#' @title Plot the ROC curve
#' @description The function `get_roc_curve` uses to plot the ROC curve for predicting immunotherapy response.
#' @param roc_data A 2 X n data fram, which contain the immunotherapy response and risk score (generated by the function `get_risk_score`) for patients.
#' @param print.auc Boolean. Should the numeric value of AUC be printed on the plot?
#' @param main A main title for the plot.
#' @importFrom pROC roc
#' @importFrom pROC plot.roc
#' @export
#' @return No return, plot the ROC curve for immunotherapy response prediction.
#' @examples
#' #Load the data.
#' data(roc_data)
#' #perform the function `get_roc_curve`.
#' get_roc_curve(roc_data,print.auc=TRUE,main="Objective Response")



get_roc_curve<-function(roc_data,print.auc=TRUE,main="Objective Response"){
  newdata<-as.data.frame(roc_data)
  lo<-which(newdata$response%in%c("PR","CR")|newdata$response%in%c("response"))
  newdata$response[lo]<-1
  newdata$response[-lo]<-0
  modelroc<-roc(as.numeric(newdata$response),as.numeric(newdata$risk_score))
  plot(modelroc,col="red",
       legacy.axes = TRUE,
       print.auc=print.auc,
       print.auc.x=0.9,print.auc.y=0.8,
       print.auc.col = "#FF0000",
       auc.polygon = FALSE,
       auc.polygon.col = "#B0E0E6",
       max.auc.polygon=FALSE,
       print.thres.col = "#FF0000",
       lwd = 2, cex.main=1.3, cex.lab=1.2,
       cex.axis=1.2, font=1.2,
       main="Objective Response")
}
