% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLreg.R
\name{plot.PLreg}
\alias{plot.PLreg}
\title{Diagnostic Plots for PLreg Objects}
\usage{
\method{plot}{PLreg}(x, which = 1:4, type = "standardized", pch = "+", las = 1, cex = 0.8, ...)
}
\arguments{
\item{x}{fitted model object of class "\code{PLreg}".}

\item{which}{numeric specifying a subset of plots (numbers between 1 and 7).
Default is \code{which = 1:4}.}

\item{type}{character specifying the type of residuals,
see \code{\link{residuals.PLreg}}. Default is \code{type = "standardized"}.}

\item{pch, las, cex, ...}{graphical parameters (see \code{\link[graphics]{par}})}
}
\value{
\code{plot} method for \code{\link{PLreg}} objects returns 7 types
of diagnostic plots.
}
\description{
This function provides plots for diagnostic analysis of
power logit regression models.
}
\details{
The \code{plot} method for \code{\link{PLreg}} objects provides 7 types
of diagnostic plots in the following order.
\describe{
\item{Residuals vs indexes of obs.}{An index plot of the residuals
versus indexes of observations.}
\item{Case-weight perturbation}{An index plot of local influence based on the
case-weight perturbation scheme.}
\item{Generalized leverage}{A dispersion diagram of the generalized leverage
versus the predicted values.}
\item{Residuals vs linear predictor}{A dispersion diagram of the residuals versus
the linear predictors.}
\item{Normal probability plot}{A normal probability plot of the residuals.}
\item{Predicted vs observed values}{A dispersion diagram of the predicted values
versus the observed values.}
\item{Residuals vs v(z) function}{A dispersion diagram of the \eqn{v(z)} function
versus the residuals. For some power logit models, the \eqn{v(z)} function
may be interpreted as weights in the estimation process. If \code{family = "NO"},
the \eqn{v(z)} function is constant.}
}
The \code{which} argument can be used to select a subset of the implemented plots.
Default is \code{which = 1:4}.
}
\examples{
data("Firm")

fitPL <- PLreg(firmcost ~ sizelog + indcost | sizelog + indcost, data = Firm,
              family = "SLASH", zeta = 2.13)
par(mfrow = c(3,3))
plot(fitPL, type = "standardized")
par(mfrow = c(1, 1))
}
\seealso{
\code{\link{PLreg}}, \code{\link{residuals.PLreg}}, \code{\link{envelope}}, \code{\link{influence}}
}
