% Generated by roxygen2 (4.0.1): do not edit by hand
\name{mod.PCR}
\alias{mod.PCR}
\title{Principal Component Regression (PCR)}
\usage{
mod.PCR(X, Y, r, ...)
}
\arguments{
\item{X}{A (NxP) predictor matrix}

\item{Y}{A (NxM) response matrix}

\item{r}{The number of PCA components}

\item{...}{Other arguments. Currently ignored}
}
\value{
The PCR parameters
}
\description{
Takes in a set of predictor variables and a set of response variables and gives the PCR parameters.
}
\examples{
if(require(pls))
data(oliveoil, package="pls")
X = as.matrix(oliveoil$chemical, ncol=5)
dimnames(X) = list(paste(c("G1","G2","G3","G4","G5","I1","I2","I3","I4","I5",
"S1","S2","S3","S4","S5","S6")),
paste(c("Acidity","Peroxide","K232","K270","DK")))
Y = as.matrix(oliveoil$sensory, ncol=6)
dimnames(Y) = list(paste(c("G1","G2","G3","G4","G5","I1","I2","I3","I4","I5",
"S1","S2","S3","S4","S5","S6")),
paste(c("Yellow","Green","Brown","Glossy","Transp","Syrup")))
mod.PCR(X, Y, r=2)
}
\author{
Opeoluwa F. Oyedele and Sugnet Gardner-Lubbe
}

