% Generated by roxygen2 (4.0.1): do not edit by hand
\name{cov.monoplot}
\alias{cov.monoplot}
\title{The covariance monoplot}
\usage{
cov.monoplot(X, ...)
}
\arguments{
\item{X}{A (NxP) predictor matrix}

\item{...}{Other arguments. Currently ignored}
}
\value{
The covariance monoplot of X
}
\description{
Takes in only one set of variables (e.g., predictors) and produces a covariance monoplot.
}
\examples{
if(require(pls))
data(oliveoil, package="pls")
Y = as.matrix(oliveoil$sensory, ncol=6)
dimnames(Y) = list(paste(c("G1","G2","G3","G4","G5","I1","I2","I3","I4",
"I5","S1","S2","S3","S4","S5","S6")),
paste(c("Yellow","Green","Brown","Glossy","Transp","Syrup")))
cov.monoplot(Y)

#cocktail data
if(require(SensoMineR))
data(cocktail, package="SensoMineR")
Y3 = as.matrix(senso.cocktail, ncol=13)
cov.monoplot(Y3)
}
\author{
Opeoluwa F. Oyedele and Sugnet Gardner-Lubbe
}

