% Generated by roxygen2 (4.0.1): do not edit by hand
\name{PLS.GLM.biplot_bvec}
\alias{PLS.GLM.biplot_bvec}
\title{A zoomed-in display of the coefficient points in the Partial Least Squares (PLS) biplot for Generalized Linear Model (GLM)}
\usage{
PLS.GLM.biplot_bvec(X, y, algorithm = NULL, ax.tickvec.b = NULL, ...)
}
\arguments{
\item{X}{A (NxP) predictor matrix}

\item{y}{A (Nx1) response vector}

\item{algorithm}{The PLS.GLM_SIMPLS algorithm}

\item{ax.tickvec.b}{(purple) tick marker length for the y-variable axis in the biplot}

\item{...}{Other arguments. Currently ignored}
}
\value{
A zoomed-in display of the coefficient points in the PLS biplot of a GLM of D=[X y] with some parameters
}
\description{
Takes in a set of predictor variables and a set of response variables and produces a zoomed-in display of the coefficient points in the PLS biplot for the (univariate) GLMs.
}
\examples{
if(require(robustbase))
possum.mat
y = as.matrix(possum.mat[,1], ncol=1)
dimnames(y) = list(paste("S", 1:nrow(possum.mat), seq=""), "Diversity")
X = as.matrix(possum.mat[,2:14], ncol=13)
dimnames(X) = list(paste("S", 1:nrow(possum.mat), seq=""), colnames(possum.mat[,2:14]))
PLS.GLM.biplot_bvec(X, y, algorithm=PLS.GLM, ax.tickvec.b=10)

#Pima.tr data
if(require(MASS))
data(Pima.tr, package="MASS")
X = as.matrix(cbind(Pima.tr[,1:7]))
dimnames(X) = list(1:nrow(X), colnames(X))
y = as.matrix(as.numeric(Pima.tr$type)-1, ncol=1)
#0=No and 1=Yes
dimnames(y) = list(1:nrow(y), paste("type"))
PLS.GLM.biplot_bvec(X, y, algorithm=PLS.binomial.GLM,ax.tickvec.b=10)
}
\author{
Opeoluwa F. Oyedele and Sugnet Gardner-Lubbe
}

