% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNmixturefit-S3methods.R
\name{coef.PLNmixturefit}
\alias{coef.PLNmixturefit}
\title{Extract model coefficients}
\usage{
\method{coef}{PLNmixturefit}(object, type = c("main", "means", "covariance", "mixture"), ...)
}
\arguments{
\item{object}{an R6 object with class \code{\link{PLNmixturefit}}}

\item{type}{type of parameter that should be extracted. Either "main" (default) for \deqn{\Theta},
"means" for \deqn{\mu}, "mixture" for \deqn{\pi} or "covariance" for \deqn{\Sigma}}

\item{...}{additional parameters for S3 compatibility. Not used}
}
\value{
A matrix of coefficients extracted from the PLNfit model.
}
\description{
Extracts model coefficients from objects returned by \code{\link[=PLN]{PLN()}} and its variants
}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPLN <- PLNmixture(Abundance ~ 1 + offset(log(Offset)),
           data = trichoptera, control_main = list(iterates = 0))  \%>\% getBestModel()
coef(myPLN) ## Theta - empty here
coef(myPLN, type = "mixture") ## pi
coef(myPLN, type = "means") ## mu
coef(myPLN, type = "covariance") ## Sigma
}
\seealso{
\code{\link[=sigma.PLNmixturefit]{sigma.PLNmixturefit()}}
}
