% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LifeExpectancy.R
\name{phe_life_expectancy}
\alias{phe_life_expectancy}
\title{Calculate Life Expectancy using phe_life_expectancy}
\usage{
phe_life_expectancy(
  data,
  deaths,
  population,
  startage,
  age_contents = c(0L, 1L, 5L, 10L, 15L, 20L, 25L, 30L, 35L, 40L, 45L, 50L, 55L, 60L,
    65L, 70L, 75L, 80L, 85L, 90L),
  le_age = "all",
  type = "full",
  confidence = 0.95
)
}
\arguments{
\item{data}{data.frame or tbl containing the deaths and population data}

\item{deaths}{field name from data containing the number of deaths within age
band; unquoted string; no default}

\item{population}{field name from data containing the population within age
band; unquoted string; no default}

\item{startage}{field name from data containing the age band; no default}

\item{age_contents}{vector; describes the contents of startage in the
ascending order. This vector is used to check whether each group in data
contains the complete set of age bands for the calculation to occur. It is also
used to reorder the data based on the startage field}

\item{le_age}{the age band to return the life expectancy for. The default is
"all", where the function returns the life expectancy values for all ages
appended onto the input table. Any other value (or vector of values) must be age bands
described by the age_contents input}

\item{type}{type of output; can be "standard" or "full" (full contains
added details on the calculation within the dataframe); quoted
string; default full}

\item{confidence}{the required level of confidence expressed as a number
between 0.9 and 1 or a number between 90 and 100 or can be a vector of 0.95
and 0.998, for example, to output both 95 percent and 99.8 percent percent CIs; numeric;
default 0.95}
}
\value{
returns a data frame containing the life expectancies and confidence intervals
for each le_age requested.  When type = 'full' additionally returns the cumulative
populations and deaths used in each LE calculation and metadata indicating parameters passed.
}
\description{
Compute life expectancy for a given age, and its standard error
}
\details{
This function aligns with the methodology in Public Health England's
Life Expectancy Calculator available on the
\href{https://fingertips.phe.org.uk/profile/guidance/supporting-information/PH-methods}{Fingertips Technical Guidance}
web page.

The function is for an abridged life table using 5 year age intervals with
a final age interval of 90+. The table has been completed using the methods
described by Chiang.(1, 2)  This age structure and methodology is used by
The Office for National Statistics to produce life expectancy at national
and local authority level.(3)

This function includes an adjustment to the method for calculating the
variance of the life expectancy estimate to include a term for the variance
associated with the final age interval. In the Chiang method the variance of
the life expectancy is the weighted sum of the variance of the probability
of survival across all the age intervals.  For the final age interval the
probability of survival is, Chiang argues, zero and has zero variance.
However, Silcocks et al argue(4) that in the case of the final age interval
the life expectancy is dependent not on the probability of survival but on
the mean length of survival \eqn{(1/M<sub>omega</sub>)}{(1/M\omega)}.
Therefore the variance associated with the final age interval depends on the
age-specific mortality rate \eqn{M<sub>omega</sub>}{M\omega}.

Life expectancy cannot be calculated if the person-years in any given age
interval is zero. It will also not be calculated if the total person-years
is less than 5,000 as this is considered to be the minimum size for robust
calculation of life expectancy.(5)  Zero death counts are not a problem,
except for the final age interval - there must be at least one death in the
90+ interval for the calculations to be possible.

Individual Life Expectancy values will be suppressed (although confidence
intervals will be shown) when the 95\% confidence interval is greater
than 20 years.

The methodology used in this function, along with discussion of alternative
options for life expectancy calculation for small areas, were described Eayres
and Williams.(6)
}
\examples{
library(dplyr)

## A simple example
df <- data.frame(startage = c(0L, 1L, 5L, 10L, 15L, 20L, 25L, 30L, 35L, 40L, 45L, 50L, 55L,
                              60L, 65L, 70L, 75L, 80L, 85L, 90L),
                 pops = c(7060L, 35059L, 46974L, 48489L, 43219L, 38561L, 46009L, 57208L,
                          61435L, 55601L, 50209L, 56416L, 46411L, 39820L, 37978L,
                          37039L, 33288L, 23306L, 11936L, 11936L),
                 deaths = c(17L, 9L, 4L, 8L, 20L, 15L, 24L, 33L, 50L, 71L, 100L, 163L,
                            263L, 304L, 536L, 872L, 1390L, 1605L, 1936L, 1937L))
phe_life_expectancy(df, deaths, pops, startage)

## or with multiple confidence limits
phe_life_expectancy(df, deaths, pops, startage, confidence = c(95, 99.8))

## OR

phe_life_expectancy(df, deaths, pops, startage, le_age = c(5, 25), type = "standard")

## Unordered age bands example
df <- data.frame(startage = c("0", "1-4", "5-9", "10 - 14", "15 - 19", "20 - 24", "25 - 29",
                              "30 - 34", "35 - 39", "40 - 44", "45 - 49", "50 - 54",
                              "55 - 59", "60 - 64", "65 - 69", "75 - 79", "80 - 84",
                              "85 - 89", "90 +", "70 - 74"),
                 pops = c(7060L, 35059L, 46974L, 48489L, 43219L, 38561L, 46009L, 57208L,
                          61435L, 55601L, 50209L, 56416L, 46411L, 39820L, 37039L,
                          23306L, 11936L, 11936L, 37978L, 33288L),
                 deaths = c(17L, 9L, 4L, 8L, 20L, 15L, 24L, 33L, 50L, 71L, 100L, 163L,
                            263L, 304L, 872L, 1605L, 1936L, 1937L, 536L, 1390L))
phe_life_expectancy(df, deaths, pops, startage,
                    age_contents = c("0", "1-4", "5-9",
                                     "10 - 14", "15 - 19",
                                     "20 - 24", "25 - 29",
                                     "30 - 34", "35 - 39",
                                     "40 - 44", "45 - 49",
                                     "50 - 54", "55 - 59",
                                     "60 - 64", "65 - 69",
                                     "70 - 74", "75 - 79",
                                     "80 - 84", "85 - 89",
                                     "90 +"))

df <- data.frame(area = c(rep("Area 1", 20), rep("Area 2", 20)),
                 startage = rep(c(0L, 1L, 5L, 10L, 15L, 20L, 25L, 30L, 35L, 40L, 45L, 50L, 55L,
                                  60L, 65L, 70L, 75L, 80L, 85L, 90L), 2),
                 pops = rep(c(7060L, 35059L, 46974L, 48489L, 43219L, 38561L, 46009L, 57208L,
                              61435L, 55601L, 50209L, 56416L, 46411L, 39820L, 37978L,
                              37039L, 33288L, 23306L, 11936L, 11936L), 2),
                 deaths = rep(c(17L, 9L, 4L, 8L, 20L, 15L, 24L, 33L, 50L, 71L, 100L, 163L,
                                263L, 304L, 536L, 872L, 1390L, 1605L, 1936L, 1937L), 2))
df \%>\%
       group_by(area) \%>\%
       phe_life_expectancy(deaths, pops, startage)

}
\references{
(1) Chiang CL. The Life Table and its Construction. In: Introduction to
Stochastic Processes in Biostatistics. New York, John Wiley & Sons, 1968:189-214. \cr \cr
(2) Newell C. Methods and Models in Demography. Chichester, John Wiley & Sons, 1994:63-81 \cr \cr
(3) Office for National Statistics Report. Life expectancy at birth by
health and local authorities in the United Kingdom, 1998 to 2000 (3-year
aggregate figures.) Health Statistics Quarterly 2002;13:83-90 \cr \cr
(4) Silcocks PBS, Jenner DA, Reza R.  Life expectancy as a summary of mortality
in a population: statistical considerations and suitability for use by health
authorities. J Epidemiol Community Health 2001;55:38-43 \cr \cr
(5) Toson B, Baker A. Life expectancy at birth: methodological options for
small populations. National Statistics  Methodological Series No 33. HMSO 2003. \cr \cr
(6) Eayres DP, Williams ES. Evaluation of methodologies for small area
life expectancy estimation. J Epidemiol Community Health 2004;58:243-249 \cr \cr
}
\seealso{
Other PHEindicatormethods package functions: 
\code{\link{assign_funnel_significance}()},
\code{\link{calculate_ISRate}()},
\code{\link{calculate_ISRatio}()},
\code{\link{calculate_funnel_limits}()},
\code{\link{calculate_funnel_points}()},
\code{\link{phe_dsr}()},
\code{\link{phe_mean}()},
\code{\link{phe_proportion}()},
\code{\link{phe_quantile}()},
\code{\link{phe_rate}()},
\code{\link{phe_sii}()}
}
\author{
Sebastian Fox, \email{sebastian.fox@phe.gov.uk}
}
\concept{PHEindicatormethods package functions}
