% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{parse}
\alias{parse}
\title{Model-based Clustering with PARSE}
\usage{
parse(tuning, K = NULL, lambda = NULL, y, N = 100, kms.iter = 100, kms.nstart = 100,
      eps.diff = 1e-5, eps.em = 1e-5, model.crit = 'gic', backward = TRUE, cores=2)
parse(tuning = NULL, K, lambda, y, N = 100, kms.iter = 100, kms.nstart = 100,
      eps.diff = 1e-5, eps.em = 1e-5, model.crit = 'gic', backward = TRUE, cores=2)
}
\arguments{
\item{tuning}{A 2-dimensional vector or a matrix with 2 columns, the first column is the number of clusters \eqn{K} and the second column is the tuning parameter \eqn{\lambda} in the penalty term. If this is missing, then \code{K} and \code{lambda} must be provided.}

\item{K}{The number of clusters \eqn{K}.}

\item{lambda}{The tuning parameter \eqn{\lambda} in the penalty term.}

\item{y}{A p-dimensional data matrix. Each row is an observation.}

\item{N}{The maximum number of iterations in the EM algorithm. The default value is 100.}

\item{kms.iter}{The maximum number of iterations in kmeans algorithm for generating the starting value for the EM algorithm.}

\item{kms.nstart}{The number of starting values in K-means.}

\item{eps.diff}{The lower bound of pairwise difference of two mean values. Any value lower than it is treated as 0.}

\item{eps.em}{The lower bound for the stopping criterion.}

\item{model.crit}{The criterion used to select the number of clusters \eqn{K}. It is either `bic' for Bayesian Information Criterion or `gic' for Generalized Information Criterion.}

\item{backward}{Use the backward selection algorithm when it equals to "TRUE", otherwise select all the possible subsets.}

\item{cores}{The number of cores which can be used in parallel computing.}
}
\value{
This function returns the esimated parameters and some statistics of the optimal model within the given \eqn{K} and \eqn{\lambda}, which is selected by BIC when \code{model.crit = 'bic'} or GIC when \code{model.crit = 'gic'}.
\item{mu.hat.best}{The estimated cluster means in the optimal model}
\item{sigma.hat.best}{The estimated covariance in the optimal model}
\item{p.hat.best}{The estimated cluster proportions in the optimal model}
\item{s.hat.best}{The clustering assignments using the optimal model}
\item{lambda.best}{The value of \eqn{\lambda} that provide the optimal model}
\item{K.best}{The value of \eqn{K} that provide the optimal model}
\item{llh.best}{The log-likelihood of the optimal model}
\item{gic.best}{The GIC of the optimal model}
\item{bic.best}{The BIC of the optimal model}
\item{ct.mu.best}{The degrees of freedom in the cluster means of the optimal model}
}
\description{
The PAirwise Reciprocal fuSE (PARSE) penalty was proposed by Wang, Zhou and Hoeting (2016). Under the framework of the model-based clustering, PARSE aims to identify the pairwise informative variables for clustering, especially for high-dimensional data.
}
\details{
The j-th variable is defined as pairwise informative for a pair of clusters \eqn{C_k} and \eqn{C_{k'}} if \eqn{\mu_{kj} \neq \mu_{k'j}}. Also, a variable is globally informative if it is pairwise informative for at least one pair of clusters. Here we assume that each cluster has the same diagonal variance in the model-based clustering. PARSE is in the following form,
\deqn{\sum_{j=1}^{d}\sum_{k<k'}|\mu_{kj} - \mu_{k'j}|^{-1} \mathbf{I}(\mu_{kj} \neq \mu_{k'j}).}
where \eqn{d} is the number of variables in the data.

The estimation uses the backward searching algorithm embedded in the EM algorithm. Since the EM algorithm depends on the starting values. We use the estimates from K-means with multiple starting points as the starting values. Please check the paper for details of the algorithm. In this function we use parallel computing to estimate cluster means for each dimension. The default number of cores to be used is 2, which can be specified by users.
}
\examples{
y <- rbind(matrix(rnorm(120,0,1),ncol=3), matrix(rnorm(120,4,1), ncol=3))
output <- parse(K = c(1:2), lambda = c(0,1), y=y, cores=2)
output$mu.hat.best
}
\references{
Wang, L., Zhou, W. and Hoeting, J. (2016) Identification of Pairwise Informative Features for Clustering Data. \emph{preprint}.
}
\seealso{
\code{\link[stats]{optim}} \code{\link{nopenalty}} \code{\link{apL1}} \code{\link{apfp}} \code{\link[foreach]{foreach}} \code{\link{doParallel}}
}
\keyword{external}

