% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeDatabase.R
\name{removeDatabase}
\alias{removeDatabase}
\title{Remove a Database from a PAMpalSettings Object}
\usage{
removeDatabase(pps, index = NULL)
}
\arguments{
\item{pps}{a \linkS4class{PAMpalSettings} object to remove a database from}

\item{index}{index indicating which database(s) to remove. Can be a vector
if you want to remove multiple databases. If missing user is prompted to
select a database from a list, will only show up to the first 20. You can
easily remove all of the databases with a large index like \code{1:1000}}
}
\value{
the same \linkS4class{PAMpalSettings} object as pps, with the database(s)
  removed from the "db" slot
}
\description{
Remove a database from the "db" slot in a PAMpalSettings
  object.
}
\examples{

exPps <- new('PAMpalSettings')
exPps <- addDatabase(exPps, system.file('extdata', 'Example.sqlite3', package='PAMpal'))
removeDatabase(exPps, 1)
if(interactive()) removeDatabase(exPps)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
