% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDetectorData.R
\name{getDetectorData}
\alias{getDetectorData}
\alias{getClickData}
\alias{getWhistleData}
\alias{getCepstrumData}
\alias{getGPLData}
\alias{getFPODData}
\alias{nDetections}
\alias{nClicks}
\alias{nWhistles}
\alias{nCepstrum}
\alias{nGPL}
\title{Extract and Combine Detector Data}
\usage{
getDetectorData(x, measures = TRUE)

getClickData(x, measures = TRUE)

getWhistleData(x, measures = TRUE)

getCepstrumData(x, measures = TRUE)

getGPLData(x, measures = TRUE)

getFPODData(x, measures = TRUE)

nDetections(x, distinct = FALSE)

nClicks(x, distinct = FALSE)

nWhistles(x)

nCepstrum(x)

nGPL(x)
}
\arguments{
\item{x}{data to extract detector data from, either an \code{AcousticStudy},
\code{AcousticEvent} or list of \code{AcousticEvent} object}

\item{measures}{logical flag whether or not to append measures to detector
dataframes}

\item{distinct}{logical flag to only return number of distinct click detections}
}
\value{
A list of data frames containing all detection data from \code{x},
  named by call type ('click', 'whistle', or 'cepstrum').
}
\description{
Extracts just the detector data from all of \code{x}, and will
  combine all detections from each call type (currently whistle, click,
  and cepstrum) into a single data frame.
}
\details{
The purpose of this function is to extract your data out of
  \code{PAMpal}'s S4 classes and put them into an easier format to work with.
  The output will be a list of up to three data frames, one for each call type
  found in your data. Each different call type will have had different processing
  applied to it by \code{processPgDetections}. Additionally, each detector will
  have its associated event id, the name of the detector, and the species id
  attached to it (species will be \code{NA} if not set). All detections from each
  call type will be combined into a single large data frame
}
\examples{

data(exStudy)
dets <- getDetectorData(exStudy)
names(dets)
str(dets$click)
# works on single events as well
oneDets <- getDetectorData(exStudy[[1]])
str(oneDets$click)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
