% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PACLasso.R
\name{transformed.ineq}
\alias{transformed.ineq}
\title{Transform Data to Fit PaC Implementation for Inequality Constraints}
\usage{
transformed.ineq(x, y, C.full, b, lambda, beta0, eps = 10^-8)
}
\arguments{
\item{x}{independent variable matrix of data to be used in calculating PaC coefficient paths}

\item{y}{response vector of data to be used in calculating PaC coefficient paths}

\item{C.full}{complete constraint matrix C (with inequality constraints of the form \code{C.full}*\code{beta} >= \code{b}))}

\item{b}{constraint vector b}

\item{lambda}{value of lambda}

\item{beta0}{initial guess for beta coefficient vector}

\item{eps}{value close to zero used to verify SVD decomposition. Default is 10^-8}
}
\value{
\code{x} transformed x data to be used in the PaC algorithm

\code{y} transformed y data to be used in the PaC algorithm

\code{Y_star} transformed Y* value to be used in the PaC algorithm

\code{a2} index of A used in the calculation of beta2 (the non-zero coefficients)

\code{beta1} beta1 values

\code{beta2} beta2 values

\code{C} constraint matrix

\code{C2} subset of constraint matrix corresponding to non-zero coefficients

\code{active.beta} index of non-zero coefficient values

\code{beta2.index} index of non-zero coefficient values
}
\description{
This function is called internally by \code{lars.c}
  to compute the transformed versions of the X, Y, and constraint
  matrix data, as shown in the PaC paper.
}
\examples{
random_data = generate.data(n = 500, p = 20, m = 10)
transform_fit = transformed.ineq(random_data$x, random_data$y,
random_data$C.full, random_data$b, lambda = 0.01, beta0 = rep(0,20))
dim(transform_fit$x)
head(transform_fit$y)
dim(transform_fit$C)
transform_fit$active.beta

}
\references{
Gareth M. James, Courtney Paulson, and Paat Rusmevichientong (JASA, 2019) "Penalized and Constrained Optimization."
(Full text available at http://www-bcf.usc.edu/~gareth/research/PAC.pdf)
}
