% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgb2spLayout.R
\name{rgb2spLayout}
\alias{rgb2spLayout}
\title{Convert an RGB \verb{Raster*} to Use with \code{spplot()}}
\usage{
rgb2spLayout(x, quantiles = c(0.02, 0.98), alpha = 1)
}
\arguments{
\item{x}{A 3-layered \verb{Raster*} object.}

\item{quantiles}{Upper and lower quantiles used for color stretching.}

\item{alpha}{Level of transparency.}
}
\description{
This function takes a red-green-blue \verb{Raster*} object and produces a list
with color information that can be passed on to the 'sp.layout' argument from
\code{\link[sp:spplot]{sp::spplot()}}.
}
\examples{
library(raster)
library(sp)

b <- brick(system.file("external/rlogo.grd", package="raster"))

## using plotRGB
plotRGB(b)

## convert brick to list
lout <- rgb2spLayout(b)
lout_alph <- rgb2spLayout(b, alpha = 0.5)

## create random spatial points for plotting
df <- data.frame(dat = rnorm(100, 2, 1),
                 x = rnorm(100, 50, 20),
                 y = rnorm(100, 50, 25))
coordinates(df) <- ~x+y

## plot spatial points with rgb background
spplot(df, sp.layout = lout)
spplot(df, sp.layout = lout_alph)

}
\seealso{
\code{\link[raster:plotRGB]{raster::plotRGB()}}.
}
\author{
Tim Appelhans, Florian Detsch
}
