% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pureBasename.R
\name{pureBasename}
\alias{pureBasename}
\title{Return File Name without Extension}
\usage{
pureBasename(path, slash = FALSE)
}
\arguments{
\item{path}{File name(s) as \code{character}.}

\item{slash}{A \code{logical} determining whether to add a leading slash (\code{"/"})
to the returned file name.}
}
\value{
File name(s) without extension as \code{character}.
}
\description{
As opposed to \code{\link[=basename]{basename()}}, this function returns the pure basename of one or
multiple file names, i.e. without extension.
}
\examples{
fls <- system.file("external/rlogo.grd", package = "raster")
pureBasename(fls)
pureBasename(fls, slash = TRUE)

}
\seealso{
\code{\link[tools:fileutils]{tools::file_path_sans_ext()}}.
}
\author{
Florian Detsch
}
