% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareDistributions.R
\name{compareDistributions}
\alias{compareDistributions}
\title{Compare two density distributions side by side}
\usage{
compareDistributions(
  left,
  right,
  add.spread = TRUE,
  print.stats = TRUE,
  xlim = NULL,
  ylim = NULL,
  clrs = c("purple", "lightblue"),
  xlab = "density",
  ylab = "value",
  ...
)
}
\arguments{
\item{left}{\code{numeric} vector.}

\item{right}{\code{numeric} vector.}

\item{add.spread}{\code{logical}, whether to plot the spread (q25 to q75 and 
the median).}

\item{print.stats}{\code{logical}, whether to print summary statistics for 
each distribution.}

\item{xlim, ylim}{\code{numeric} axis limits, see 
\code{\link[lattice]{xyplot}}.}

\item{clrs}{A \code{character} vector of length 2 specifying the colors 
for the filled density regions.}

\item{xlab, ylab}{\code{character} axis labels, see \code{\link{plot}}.}

\item{...}{Additional arguments passed to \code{\link{density}}.}
}
\value{
A \code{trellis} object.
}
\description{
This function will produce a plot of two density functions displayed 
side by side
}
\examples{
compareDistributions(rnorm(1000, 2, 3), rnorm(1000, -5, 1))
compareDistributions(rnorm(1000, 2, 3), rnorm(1000, -5, 1), 
                     add.spread = FALSE)
compareDistributions(rnorm(1000, 2, 3), rnorm(1000, -5, 1), 
                     add.spread = TRUE, clrs = c("red", "brown"))
compareDistributions(rnorm(1000, 2, 5), rnorm(1000, -5, 4), 
                     print.stats = FALSE, add.spread = FALSE)
                     
## pass additional parameters to density() 
compareDistributions(rnorm(1000, 2, 5), rnorm(1000, -5, 4), 
                     print.stats = FALSE, add.spread = FALSE, bw = 5)
compareDistributions(rnorm(1000, 2, 5), rnorm(1000, -5, 4), 
                     print.stats = FALSE, add.spread = FALSE, bw = 8,
                     kernel = "rectangular")
compareDistributions(rnorm(1000, 2, 5), rnorm(1000, -5, 4), 
                     print.stats = FALSE, add.spread = TRUE, bw = 8,
                     n = 3)
compareDistributions(rnorm(1000, 2, 5), rnorm(1000, -5, 4), 
                     print.stats = TRUE, add.spread = TRUE, bw = 0.1)
compareDistributions(rnorm(1000, 2, 5), rnorm(1000, -5, 4), 
                     print.stats = TRUE, add.spread = TRUE, bw = 0.5)                    

}
\author{
Tim Appelhans
}
