/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractOsmTileSource;

public class StamenLayerTileSource
extends AbstractOsmTileSource {
    private String exten;

    public StamenLayerTileSource(String layer, String ext) {
        super("stamen-" + layer, "http://tile.stamen.com/" + layer);
        this.exten = ext;
    }

    public TileSource.TileUpdate getTileUpdate() {
        return TileSource.TileUpdate.IfNoneMatch;
    }

    public int getMaxZoom() {
        return 15;
    }

    public String getAttributionText(int zoom, Coordinate topLeft, Coordinate botRight) {
        return "\u00ac\u00a9 Map tiles by Stamen Design, under CC BY 3.0. Data by OpenStreetMap, under CC BY SA.";
    }

    public String getAttributionLinkURL() {
        return "http://maps.stamen.com/";
    }

    public String getTermsOfUseURL() {
        return "http://maps.stamen.com/";
    }

    public String getTileType() {
        return this.exten;
    }
}

