/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import org.openstreetmap.gui.jmapviewer.JMapController;
import org.openstreetmap.gui.jmapviewer.JMapViewer;

public class DefaultMapController
extends JMapController
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    protected static final int MOUSE_BUTTONS_MASK = 7168;
    protected static final int MAC_MOUSE_BUTTON3_MASK = 1152;
    protected Point lastDragPoint;
    protected boolean isMoving = false;
    protected boolean movementEnabled = true;
    protected int movementMouseButton = 3;
    protected int movementMouseButtonMask = 4096;
    protected boolean wheelZoomEnabled = true;
    protected boolean doubleClickZoomEnabled = true;

    public DefaultMapController(JMapViewer jMapViewer) {
        super(jMapViewer);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.movementEnabled || !this.isMoving) {
            return;
        }
        if ((mouseEvent.getModifiersEx() & 0x1C00) == this.movementMouseButtonMask) {
            Point point = mouseEvent.getPoint();
            if (this.lastDragPoint != null) {
                int n = this.lastDragPoint.x - point.x;
                int n2 = this.lastDragPoint.y - point.y;
                this.map.moveMap(n, n2);
            }
            this.lastDragPoint = point;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.doubleClickZoomEnabled && mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
            this.map.zoomIn(mouseEvent.getPoint());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == this.movementMouseButton || DefaultMapController.isPlatformOsx() && mouseEvent.getModifiersEx() == 1152) {
            this.lastDragPoint = null;
            this.isMoving = true;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == this.movementMouseButton || DefaultMapController.isPlatformOsx() && mouseEvent.getButton() == 1) {
            this.lastDragPoint = null;
            this.isMoving = false;
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.wheelZoomEnabled) {
            this.map.setZoom(this.map.getZoom() - mouseWheelEvent.getWheelRotation(), mouseWheelEvent.getPoint());
        }
    }

    public boolean isMovementEnabled() {
        return this.movementEnabled;
    }

    public void setMovementEnabled(boolean bl) {
        this.movementEnabled = bl;
    }

    public int getMovementMouseButton() {
        return this.movementMouseButton;
    }

    public void setMovementMouseButton(int n) {
        this.movementMouseButton = n;
        switch (n) {
            case 1: {
                this.movementMouseButtonMask = 1024;
                break;
            }
            case 2: {
                this.movementMouseButtonMask = 2048;
                break;
            }
            case 3: {
                this.movementMouseButtonMask = 4096;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported button");
            }
        }
    }

    public boolean isWheelZoomEnabled() {
        return this.wheelZoomEnabled;
    }

    public void setWheelZoomEnabled(boolean bl) {
        this.wheelZoomEnabled = bl;
    }

    public boolean isDoubleClickZoomEnabled() {
        return this.doubleClickZoomEnabled;
    }

    public void setDoubleClickZoomEnabled(boolean bl) {
        this.doubleClickZoomEnabled = bl;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (DefaultMapController.isPlatformOsx()) {
            if (!this.movementEnabled || !this.isMoving) {
                return;
            }
            if (mouseEvent.getModifiersEx() == 128) {
                Point point = mouseEvent.getPoint();
                if (this.lastDragPoint != null) {
                    int n = this.lastDragPoint.x - point.x;
                    int n2 = this.lastDragPoint.y - point.y;
                    this.map.moveMap(n, n2);
                }
                this.lastDragPoint = point;
            }
        }
    }

    public static boolean isPlatformOsx() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().startsWith("mac os x");
    }
}

