% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manage_lib.R
\name{check_lib}
\alias{check_lib}
\alias{get_lib}
\alias{load_lib}
\title{Manage spectral libraries}
\usage{
check_lib(
  which = c("ftir", "raman"),
  types = c("metadata", "library", "peaks"),
  path = "system",
  condition = "warning"
)

get_lib(
  which = c("ftir", "raman"),
  types = c("metadata", "library", "peaks"),
  path = "system",
  node = "x7dpz",
  conflicts = "overwrite",
  ...
)

load_lib(
  which = c("ftir", "raman"),
  types = c("metadata", "library", "peaks"),
  path = "system"
)
}
\arguments{
\item{which}{a character string specifying which library to use,
\code{"raman"} or \code{"ftir"}.}

\item{types}{library types to check/retrieve; defaults to
\code{c("metadata", "library", "peaks")}.}

\item{path}{where to save or look for local library files; defaults to
\code{"system"} pointing to
\code{system.file("extdata", package = "OpenSpecy")}.}

\item{condition}{determines if \code{check_lib()} should warn
(\code{"warning"}, the default) or throw and error (\code{"error"}).}

\item{node}{the OSF node to be retrieved; should be \code{"x7dpz"}.}

\item{conflicts}{determines what happens when a file with the same name
exists at the specified destination. Can be one of the following (see
\code{\link[osfr]{osf_download}()} for details):
\itemize{
  \item{"error"}{ throw an error and abort the file transfer operation.}
  \item{"skip"}{ skip the conflicting file(s) and continue transferring the
  remaining files.}
  \item{"overwrite" (default)}{ replace the existing file with the
  transferred copy.}
}}

\item{\ldots}{further arguments passed to \code{\link[osfr]{osf_download}()}.}
}
\value{
\code{check_lib()} and \code{get_lib()} return messages only;
\code{load_lib()} returns a list object containing the respective spectral
reference library.
}
\description{
These functions will import the spectral libraries from Open Specy if they
were not already downloaded.
The CRAN does not allow for deployment of large datasets so this was a
workaround that we are using to make sure everyone can easily get Open Specy
functionality running on their desktop.
}
\details{
\code{check_lib()} checks to see if the Open Specy reference library
already exists on the users computer.
\code{get_lib()} downloads the Open Specy library from OSF
(\doi{10.17605/OSF.IO/X7DPZ}).
\code{load_lib()} will load the library into the global environment for use
with the Open Specy functions.
}
\examples{
\dontrun{
check_lib(which = c("ftir", "raman"))
get_lib(which = c("ftir", "raman"))

spec_lib <- load_lib(which = c("ftir", "raman"))
}

}
\references{
Cowger W, Gray A, Christiansen SH, Christiansen SH, Christiansen SH,
De Frond H, Deshpande AD, Hemabessiere L, Lee E, Mill L, et al. (2020).
“Critical Review of Processing and Classification Techniques for Images and
Spectra in Microplastic Research.” \emph{Applied Spectroscopy},
\strong{74}(9), 989–1010. \doi{10.1177/0003702820929064}.

Cowger, W (2021). “Library data.” \emph{OSF}. \doi{10.17605/OSF.IO/X7DPZ}.
}
\seealso{
\code{\link{match_spec}()}
}
\author{
Zacharias Steinmetz
}
