\name{bertin}
\alias{bertin}
\title{Make Bertin display of grid data.}
\usage{
  bertin(x, colors = c("white", "black"),
    showvalues = TRUE, xlim = c(0.2, 0.8),
    ylim = c(0, 0.6), margins = c(0, 1, 1),
    cex.elements = 0.7, cex.constructs = 0.7,
    cex.text = 0.6, col.text = NA, border = "white",
    lheight = 0.75, id = c(T, T), cc = 0, cr = 0,
    cc.old = 0, cr.old = 0, col.mark.fill = "#FCF5A4",
    print = TRUE, ...)
}
\arguments{
  \item{x}{\code{repgrid} object.}

  \item{colors}{Vector. Two or more colors defininig the
  color ramp for the bertin (default \code{c("white",
  "black")}).}

  \item{showvalues}{Logical. Wether scores are shown in
  bertin}

  \item{xlim}{Vector. Left and right limits inner bertin
  (default \code{c(.2, .8)}).}

  \item{ylim}{Vector. Lower and upper limits of inner
  bertin default(\code{c(.0, .6)}).}

  \item{margins}{Vector of length three (default
  \code{margins=c(0,1,1)}).  1st element denotes the left,
  2nd the upper and 3rd the right margin in npc coordinates
  (i.e. 0 to zero).}

  \item{cex.elements}{Numeric. Text size of element labels
  (default \code{.7}).}

  \item{cex.constructs}{Numeric. Text size of construct
  labels (default \code{.7}).}

  \item{cex.text}{Numeric. Text size of scores in bertin
  cells (default \code{.7}).}

  \item{col.text}{Color of scores in bertin (default
  \code{NA}). By default the color of the text is chosen
  according to the background color. If the background ist
  bright the text will be black and vice versa. When a
  color is specified the color is set independetn of
  background.}

  \item{border}{Border color of the bertin cells (default
  \code{white}).}

  \item{lheight}{Line height for constructs.}

  \item{id}{Logical. Wheteher to print id number for
  constructs and elements respectively (default
  \code{c(T,T)}).}

  \item{cc}{Numeric. Current column to mark.}

  \item{cr}{Numeric. Current row to mark.}

  \item{cc.old}{Numeric. Column to unmark.}

  \item{cr.old}{Numeric. Row to unmark.}

  \item{col.mark.fill}{Color of marked row or column
  (default \code{"#FCF5A4"}).}

  \item{print}{Print whole bertin. If \code{FALSE} only
  current and old row and column are printed.}

  \item{...}{Optional arguments to be passed on to
  \code{bertinBase}.}
}
\value{
  \code{NULL} just for the side effects, i.e. printing.
}
\description{
  One of the most popular ways of displaying grid data has
  been adopted from Bertin's (1974) graphical proposals,
  which have had an immense influence onto data
  visualization. One of the most appealing ideas presented
  by Bertin is the concept of the reordable matrix. It is
  comprised of graphical displays for each cell, allowing
  to identify structures by eye-balling reordered versions
  of the data matrix (see Bertin, 1974). In the context of
  repertory grids, the display is made up of a simple
  colored rectangle where the color denotes the
  corresponding score. Bright values correspond to low,
  dark to high scores. For an example of how to analyze a
  Bertin display see e.g. Dick (2000) and Raeithel (1998).
}
\examples{
\dontrun{

   bertin(feixas2004)
   bertin(feixas2004, c("white", "darkblue"))
   bertin(feixas2004, showvalues=F)
   bertin(feixas2004, border="grey")
   bertin(feixas2004, cex.text=.9)
   bertin(feixas2004, id=c(F, F))

   bertin(feixas2004, cc=3, cr=4)
   bertin(feixas2004, cc=3, cr=4, col.mark.fill="#e6e6e6")
}
}
\references{
  Bertin, J. (1974). \emph{Graphische Semiologie:
  Diagramme, Netze, Karten}. Berlin, New York: de Gruyter.

  Dick, M. (2000). The Use of Narrative Grid Interviews in
  Psychological Mobility Research. \emph{Forum Qualitative
  Sozialforschung / Forum: Qualitative Social Research,
  1}(2).

  Raeithel, A. (1998). Kooperative Modellproduktion von
  Professionellen und Klienten - erlauetert am Beispiel des
  Repertory Grid. \emph{Selbstorganisation, Kooperation,
  Zeichenprozess: Arbeiten zu einer
  kulturwissenschaftlichen, anwendungsbezogenen
  Psychologie} (pp. 209-254). Opladen: Westdeutscher
  Verlag.
}

