% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.r
\name{saveAsExcel}
\alias{saveAsExcel}
\title{Save grid in a Microsoft Excel file (.xlsx)}
\usage{
saveAsExcel(x, file, sheet = 1)
}
\arguments{
\item{x}{A \code{repgrid} object.}

\item{file}{Filename to save the grid to. The name should have 
the suffix \code{.xlsx}.}

\item{sheet}{Index of the sheet to write to.}
}
\value{
Invisibly returns the name of the file.
}
\description{
\code{saveAsExcel} will save the grid as a Microsoft Excel file 
(\code{.xlsx}).
}
\examples{
\dontrun{

 x <- randomGrid(options=0)
 saveAsExcel(x, "grid.xlsx")

}

}
\seealso{
\code{\link{importExcel}}
}
\author{
Mark Heckmann
}
