% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OneR.R
\name{eval_model}
\alias{eval_model}
\title{Classification Evaluation function}
\usage{
eval_model(prediction, actual)
}
\arguments{
\item{prediction}{vector which contains the predicted values.}

\item{actual}{dataframe which contains the actual data. When there is more than one column the last last column is taken. A single vector is allowed too.}
}
\description{
Function for evaluating a OneR classification model. Prints prediction vs. actual in absolute and relative numbers. Additionally it gives the accuracy and error rate.
}
\details{
Invisibly returns a list with the number of correctly classified and total instances and a contingency table with the absolute numbers.
}
\examples{
data <- iris
model <- OneR(data)
summary(model)
prediction <- predict(model, data)
eval_model(prediction, data)
}
\author{
Holger von Jouanne-Diedrich
}
\references{
\url{http://vonjd.github.io/OneR/}
}
\keyword{accuracy}
\keyword{evaluation}

