% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/critical_quantile.R
\name{critical_quantile}
\alias{critical_quantile}
\alias{critical_quantile.blrmfit}
\alias{critical_quantile.blrm_trial}
\title{Critical quantile}
\usage{
critical_quantile(object, ...)

\method{critical_quantile}{blrmfit}(
  object,
  newdata,
  x,
  p,
  qc,
  lower.tail,
  interval.x,
  extendInt.x = c("auto", "no", "yes", "downX", "upX"),
  log.x,
  predictive = FALSE,
  maxiter = 100,
  ...
)

\method{critical_quantile}{blrm_trial}(
  object,
  newdata,
  x,
  p,
  qc,
  lower.tail,
  interval.x,
  extendInt.x = c("auto", "no", "yes", "downX", "upX"),
  log.x,
  predictive = FALSE,
  maxiter = 100,
  ...
)
}
\arguments{
\item{object}{fitted model object}

\item{...}{not used in this function}

\item{newdata}{optional data frame specifying for what to predict;
if missing, then the data of the input model \code{object} is
used}

\item{x}{character giving the covariate name which is being search
for to meet the critical conditions.  This also supports 'tidy'
parameter selection by specifying \code{x = vars(...)}, where
\code{...}  is specified the same way as in
\code{\link[dplyr:select]{dplyr::select()}} and similar
functions. Examples of using \code{x} in this way can be found
in the examples. For \code{blrm_trial} methods, it defaults to
the first entry in \code{summary(blrm_trial,
"drug_info")$drug_name}.}

\item{p}{cumulative probability corresponding to the critical
quantile range.}

\item{qc}{if given as a sorted vector of length 2, then the two
entries define the interval on the response rate scale which
must correspond to the cumulative probability \code{p}. In this
case \code{lower.tail} must be \code{NULL} or left missing. If
\code{qc} is only a single number, then \code{lower.tail} must
be set to complete the specification of the tail area.}

\item{lower.tail}{defines if probabilities are lower or upper tail
areas. Must be defined if \code{qc} is a single number and must
not be defined if \code{qc} denotes an interval.}

\item{interval.x}{interval the covariate \code{x} is
searched. Defaults to the minimal and maximal value of \code{x}
in the data set used. Whenever \code{lower.tail} is set such
that it is known that a tail area is used, then the function
will automatically attempt to enlarge the search interval since
the direction of the inverted function is determined around the
critical value.}

\item{extendInt.x}{controls if the interval given in
\code{interval.x} should be extended during the root
finding. The default \code{"auto"} attempts to guess an
adequate setting in cases thats possible. Other possible values
are the same as for the \code{extendInt} argument of the
\code{\link[stats:uniroot]{stats::uniroot()}} function.}

\item{log.x}{determines if during the numerical search for the
critical value the covariate space is logarithmized. By default
\code{x} is log transformed whenever all values are positive.}

\item{predictive}{logical indicates if the critical quantile
relates to the posterior (\code{FALSE}) or the predictive
(\code{TRUE}) distribution. Defaults to \code{FALSE}.}

\item{maxiter}{maximal number of iterations for root
finding. Defaults to \code{100}.}
}
\value{
Vector of length equal to the number of rows of the input
    data set with the crticial value for the covariate specified as
    \code{x} which fullfills the requirements as detailled
    above. May return \code{NA} for cases where no solution is
    found on the specified interval \code{interval.x}.
}
\description{
Calculates the critical value of a model covariate for
    which a fixed quantile of the crude rate is equal to the
    specified (tail or interval) probability. The specified
    quantile can relate to the posterior or the predictive
    distribution of the response rate.
}
\details{
The function searches for a critical value \eqn{x_c} of the covariate
\eqn{x} (\code{x}) at which the integral over the model response in the
specified interval \eqn{\pi_1} to \eqn{\pi_2} (\code{qc}) is equal to the
given probability \eqn{p} (\code{p}). The given interval is considered
a tail area when \code{lower.tail} is used such that \eqn{\pi_1 = 0}
for \code{TRUE} and \eqn{\pi_2=1} for \code{FALSE}. At the
critical value \eqn{x_c} the equality holds

\deqn{p = \int_{\pi_1}^{\pi_2} p(\pi | x_c) \, d\pi .}

A solution is only guranteed to exist whenever a tail probability
is calculated. In case an interval probability is specified, then
the solution may not necessarily exist and the root finding is
confined to the range specified in \code{interval.x}.

In case the solution is requested for the predictive distribution
(\code{predictive=TRUE}), then the respective problem solved leads
to the equality of

\deqn{p = \sum_{y= r_1 = \lceil n \, \pi_1 \rceil }^{r_2 = \lceil n \, \pi_2 \rceil } \int p(y|\pi, n) \, p(\pi | x_c) \, d\pi .}

Furthermore, the covariate space is log transformed by default
whenever all values of the covariate \eqn{x} are positive in the data
set. Values of \eqn{0} are shifted into the positive domain by the
machine precision to avoid issues with an ill-defined \eqn{\log(0)}.

For \code{blrm_trial} objects the default arguments for \code{p},
\code{qc} and \code{lower.tail} are set to correspond to the
highest interval of \code{interval_prob} to be constrained by the
respective \code{interval_max_mass} (which are defined as part of
the \code{blrm_trial} objects). This will in the default case
correspond to the EWOC metric. These defaults are only applied if
\code{p}, \code{qc} and \code{lower.tail} are missing.
}
\examples{
## Setting up dummy sampling for fast execution of example
## Please use 4 chains and 100x more warmup & iter in practice
.user_mc_options <- options(OncoBayes2.MC.warmup=10, OncoBayes2.MC.iter=20, OncoBayes2.MC.chains=1,
                            OncoBayes2.MC.save_warmup=FALSE)

# fit an example model. See documentation for "combo2" example
example_model("combo2", silent=TRUE)

# Find dose of drug_A at which EWOC criterium is just fulfilled
data_trial_ab <- subset(codata_combo2, group_id=="trial_AB")
drug_A_crit <- critical_quantile(blrmfit, newdata=data_trial_ab,
                                 x="drug_A", p=0.25, qc=0.33,
                                 lower.tail=FALSE)
data_trial_ab$drug_A <- drug_A_crit
summary(blrmfit, newdata=data_trial_ab, interval_prob=c(0,0.16,0.33,1))

## Recover user set sampling defaults
options(.user_mc_options)

}
