% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OmicsPLS_o2m.R
\name{so2m_group}
\alias{so2m_group}
\title{Perform Group Sparse O2PLS}
\usage{
so2m_group(
  X,
  Y,
  n,
  nx,
  ny,
  groupx = NULL,
  groupy = NULL,
  keepx = NULL,
  keepy = NULL,
  tol = 1e-10,
  max_iterations = 1000,
  max_iterations_sparsity = 1000
)
}
\arguments{
\item{X}{Numeric matrix. Vectors will be coerced to matrix with \code{as.matrix} (if this is possible)}

\item{Y}{Numeric matrix. Vectors will be coerced to matrix with \code{as.matrix} (if this is possible)}

\item{n}{Integer. Number of joint PLS components. Must be positive.}

\item{nx}{Integer. Number of orthogonal components in \eqn{X}. Negative values are interpreted as 0}

\item{ny}{Integer. Number of orthogonal components in \eqn{Y}. Negative values are interpreted as 0}

\item{groupx}{Vector. Used when \code{sparse = TRUE}. A vector of strings indicating group names of each X-variable. Its length must be equal to the number of variables in \eqn{X}. The order of group names must corresponds to the order of the variables.}

\item{groupy}{Vector. Used when \code{sparse = TRUE}. A vector of strings indicating group names of each Y-variable. The length must be equal to the number of variables in \eqn{Y}. The order of group names must corresponds to the order of the variables.}

\item{keepx}{Vector. Used when \code{sparse = TRUE}. A vector of length \code{n} indicating how many variables (or groups if \code{groupx} is provided) to keep in each of the joint component of \eqn{X}. If the input is an integer, all the components will have the same amount of variables or groups retained.}

\item{keepy}{Vector. Used when \code{sparse = TRUE}. A vector of length \code{n} indicating how many variables (or groups if \code{groupx} is provided) to keep in each of the joint component of \eqn{Y}. If the input is an integer, all the components will have the same amount of variables or groups retained.}

\item{tol}{Double. Threshold for which the NIPALS method is deemed converged. Must be positive.}

\item{max_iterations}{Integer. Maximum number of iterations for the NIPALS method.}

\item{max_iterations_sparsity}{Integer. Used when \code{sparse = TRUE}. Maximum number of iterations for the NIPALS method for GO2PLS.}
}
\value{
A list containing
   \item{Tt}{Joint \eqn{X} scores}
   \item{W.}{Joint \eqn{X} loadings}
   \item{U}{Joint \eqn{Y} scores}
   \item{C.}{Joint \eqn{Y} loadings}
   \item{T_Yosc}{Orthogonal \eqn{X} scores}
   \item{P_Yosc.}{Orthogonal \eqn{X} loadings}
   \item{W_Yosc}{Orthogonal \eqn{X} weights}
   \item{U_Xosc}{Orthogonal \eqn{Y} scores}
   \item{P_Xosc.}{Orthogonal \eqn{Y} loadings}
   \item{C_Xosc}{Orthogonal \eqn{Y} weights}
   \item{B_U}{Regression coefficient in \code{Tt} ~ \code{U}}
   \item{B_T.}{Regression coefficient in \code{U} ~ \code{Tt}}
   \item{H_TU}{Residuals in \code{Tt} in \code{Tt} ~ \code{U}}
   \item{H_UT}{Residuals in \code{U} in \code{U} ~ \code{Tt}}
   \item{W_gr}{Joint weights of X variables at group level. They are the norms of the X-joint loadings per group}
   \item{C_gr}{Joint weights of Y variables at group level. They are the norms of the Y-joint loadings per group}
}
\description{
Perform Group Sparse O2PLS
}
\seealso{
\code{\link{o2m}}
}
\keyword{internal}
