% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Crossval_OmicsPLS.R
\name{crossval_sparsity}
\alias{crossval_sparsity}
\title{Perform cross-validation to find the optimal number of variables/groups to keep for each joint component}
\usage{
crossval_sparsity(
  X,
  Y,
  n,
  nx,
  ny,
  nr_folds,
  keepx_seq = NULL,
  keepy_seq = NULL,
  groupx = NULL,
  groupy = NULL,
  tol = 1e-10,
  max_iterations = 100
)
}
\arguments{
\item{X}{Numeric matrix. Vectors will be coerced to matrix with \code{as.matrix} (if this is possible)}

\item{Y}{Numeric matrix. Vectors will be coerced to matrix with \code{as.matrix} (if this is possible)}

\item{n}{Integer. Number of joint PLS components. Must be positive.}

\item{nx}{Integer. Number of orthogonal components in \eqn{X}. Negative values are interpreted as 0}

\item{ny}{Integer. Number of orthogonal components in \eqn{Y}. Negative values are interpreted as 0}

\item{nr_folds}{Integer. Number of folds of CV}

\item{keepx_seq}{Numeric vector. A vector indicating how many variables/groups to keep for CV in each of the joint component of X. Sparsity of each joint component will be selected sequentially.}

\item{keepy_seq}{Numeric vector. A vector indicating how many variables/groups to keep for CV in each of the joint component of Y. Sparsity of each joint component will be selected sequentially.}

\item{groupx}{Vector. Used when \code{sparse = TRUE}. A vector of strings indicating group names of each X-variable. Its length must be equal to the number of variables in \eqn{X}. The order of group names must corresponds to the order of the variables.}

\item{groupy}{Vector. Used when \code{sparse = TRUE}. A vector of strings indicating group names of each Y-variable. The length must be equal to the number of variables in \eqn{Y}. The order of group names must corresponds to the order of the variables.}

\item{tol}{Double. Threshold for which the NIPALS method is deemed converged. Must be positive.}

\item{max_iterations}{Integer. Maximum number of iterations for the NIPALS method.}
}
\value{
A list containing
   \item{x_1sd}{A vector with length n, giving the optimal number of variables/groups to keep for each X-joint compoent. One standard error rule is applied}
   \item{y_1sd}{A vector with length n, giving the optimal number of variables/groups to keep for each Y-joint compoent. One standard error rule is applied}
   \item{x}{A vector with length n, giving the optimal number of variables/groups to keep for each X-joint compoent, without applying the one standard error rule}
   \item{y}{A vector with length n, giving the optimal number of variables/groups to keep for each Y-joint compoent, without applying the one standard error rule}
}
\description{
Perform cross-validation to find the optimal number of variables/groups to keep for each joint component
}
