% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OmicsPLS.R
\name{adjR2}
\alias{adjR2}
\title{Gridwise adjusted R2 for O2PLS}
\usage{
adjR2(X, Y, a = 1:2, a2 = 1, b2 = 1, func = o2m, parall = F,
  cl = NULL, stripped = TRUE, p_thresh = 3000, q_thresh = p_thresh,
  tol = 1e-10, max_iterations = 100)
}
\arguments{
\item{X}{Numeric matrix. Vectors will be coerced to matrix with \code{as.matrix} (if this is possible)}

\item{Y}{Numeric matrix. Vectors will be coerced to matrix with \code{as.matrix} (if this is possible)}

\item{a}{Vector of integers. Contains the numbers of joint components.}

\item{a2}{Vector of integers. Contains the numbers of orthogonal components in \eqn{X}.}

\item{b2}{Vector of integers. Contains the numbers of orthogonal components in \eqn{Y}.}

\item{func}{Function to fit the O2PLS model with. Only \code{\link{o2m}} and \code{\link{o2m_stripped}} are supported.}

\item{parall}{Integer. Should a parallel cluster be set up using package \code{parallel} (Windows)? Best is to leave it to \code{FALSE}.}

\item{cl}{Object of class '\code{cluster}'. If parall is \code{TRUE} and \code{cl} is not \code{NULL}, calculations are parallelized over workers in cl.}

\item{stripped}{Logical. Use the stripped version of o2m (usually when cross-validating)?}

\item{p_thresh}{Integer. If \code{X} has more than \code{p_thresh} columns, a power method optimization is used, see \code{\link{o2m2}}}

\item{q_thresh}{Integer. If \code{Y} has more than \code{q_thresh} columns, a power method optimization is used, see \code{\link{o2m2}}}

\item{tol}{double. Threshold for power method iteration}

\item{max_iterations}{Integer, Maximum number of iterations for power method}
}
\value{
Matrix with two rows:
\item{adjR2X}{Contains the joint R2 in X}
\item{adjR2Y}{Contains the joint R2 in Y}
}
\description{
For (a grid of) values for \code{a}, \code{nx} and \code{ny}, \code{loocv} calculates the R2 of the joint part. Parallel computing is supported on Windows with package \code{parallel}.
}
\details{
The use of this function is to calculate the R2 of the joint part, while varying the number of orthogonal components. Adding more joint components will increase the R2!

A parallelized version is built in -tested on windows-, use package \code{parallel} and set \code{parall=TRUE} to activate this. There should not be already a cluster object with the name \code{cl}.
In case of some error, don't forget to invoke \code{stopCluster(cl)} to end the cluster. See Task Manager (Windows) to verify that the workers are spanned/ended.

See \code{\link{loocv}} for more intuition.
}
