% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/os.pca.R
\name{os.pca}
\alias{os.pca}
\title{Visualize predictors using principal coordinate analysis}
\usage{
os.pca(x, y, method = "linear", thresh = 0, n.pred = ncol(x), size = 1)
}
\arguments{
\item{x}{A data matrix (row: samples, col: predictors).}

\item{y}{A vector of target value.}

\item{method}{A string to specify the regression function for calculating R-squared values.
"linear" (default), "quadratic" or "cubic" function can be specified.}

\item{thresh}{The lower threshold of R-squared value to be indicated in a PCA plot (default: 0).}

\item{n.pred}{The number of candidate predictors for prediction model to be indicated in a PCA plot (default: ncol(x)).}

\item{size}{The size of symbols in a PCA plot (default: 1).}
}
\value{
A PCA plot
}
\description{
Visualize predictors using principal coordinate analysis
}
\examples{
data(Pinus)
train <- os.clean(Pinus$train)
target <- Pinus$target
os.pca(train, target)
}
\author{
Takahiko Koizumi
}
