/*
 * Decompiled with CFR 0.152.
 */
package org.andwellness.xml.datagenerator.creator;

import java.util.Map;
import nu.xom.Node;
import org.andwellness.xml.datagenerator.creator.DataPointCreator;
import org.andwellness.xml.datagenerator.model.DataPoint;
import org.andwellness.xml.datagenerator.utility.ValueCreator;

public class TextDataPointCreator
extends DataPointCreator {
    private char[] chars = "abcdefghijklmnopqrstuvwxyz 0123456789".toCharArray();

    @Override
    public DataPoint create(Node currentNode) {
        String displayType = currentNode.query("displayType").get(0).getValue();
        String nodeId = currentNode.query("id").get(0).getValue();
        DataPoint createdDataPoint = new DataPoint();
        createdDataPoint.setId(nodeId);
        createdDataPoint.setPromptType(DataPoint.PromptType.text);
        createdDataPoint.setDisplayType(displayType);
        Node propertyNode = currentNode.query("properties").get(0);
        Map<String, String> nodeProperties = this.extractProperties(propertyNode);
        int min = Integer.parseInt(nodeProperties.get("min"));
        int max = Integer.parseInt(nodeProperties.get("max"));
        int length = ValueCreator.randomPositiveIntModulus(max - min + 1) + min;
        String randomString = "";
        while (this.empty(randomString)) {
            randomString = this.randomString(length);
        }
        createdDataPoint.setValue(randomString);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Creating a text data point with id " + nodeId + " value " + "sample text");
        }
        return createdDataPoint;
    }

    private String randomString(int length) {
        int numberOfChars = this.chars.length;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(this.chars[ValueCreator.randomPositiveIntModulus(numberOfChars)]);
        }
        return builder.toString();
    }

    private boolean empty(String string) {
        return "".equals(string.trim());
    }
}

