% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{Gini}
\alias{Gini}
\title{A function to compute Spatial Gini's segregation index}
\usage{
Gini(x)
}
\arguments{
\item{x}{- an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a group within 
spatial units. The number of columns should be greater than 1 (at least 2 
groups are required). You should not include a column with total 
population, because this will be interpreted as a group.}
}
\value{
a numeric vector containing the Gini's segregation index value for 
each group
}
\description{
The spatial version of the Gini index can be derived from 
the Lorenz curve as the area between the segregation curve and the 
diagonal.
}
\examples{
x <- segdata@data[ ,1:2]
Gini(x)
}
\references{
Duncan O. D. and Duncan B. (1955) \emph{A Methodological 
Analysis of Segregation Indexes}. American Sociological Review 41, 
pp. 210-217
}
\seealso{
Other one-group  evenness indices: 
\code{\link{ISDuncan}}, \code{\link{Atkinson}}, \code{\link{Gorard}}, 
\code{\link{HTheil}}, '\code{\link{ISWong}}, \code{\link{ISMorrill}},
\code{\link{ISMorrillK}}

Between groups dissimilarity indices: 
\code{\link{DIDuncan}}, \code{\link{Gini2}}, 
\code{\link{DIMorrill}}, \code{\link{DIMorrillK}}, \code{\link{DIWong}}
}
