% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/GeoFunctions.R
\name{xgeo}
\alias{xgeo}
\title{A function to compute all spatial info for segregation indexes}
\usage{
xgeo(spatobj = NULL, folder = NULL, shape = NULL, center = 1)
}
\arguments{
\item{spatobj}{- a Spatial object (SpatialPolygonsDataFrame)}

\item{folder}{- a character vector with the folder (directory)
where the shapefile is}

\item{shape}{- a character vector with the name of the shapefile
(without the .shp extension)}

\item{center}{- the row number of the center}
}
\value{
A list that contains all geographic information
needed to calculate segregation indexes.
}
\description{
The function is based on \pkg{rgdal}, \pkg{rgeos}
and \pkg{spdep} packages and it can be used by providing a
shape file or a R spatial object (SpatialPolygonsDataFrame).
}
\examples{
xgeo(AnnHAge, center = 1)

foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'AnnHAge'
xgeo(folder = foldername, shape = shapename, center = 19)
}
\seealso{
Other spatial functions used for segregation indices
computation:  \code{\link{area}}, \code{\link{contig}},
\code{\link{perimeter}}, \code{\link{distance}},
\code{\link{distcenter}}, \code{\link{boundaries}}
}

